/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Objects;

public class AddNamespaceDecorator
extends NamedResourceDecorator<ObjectMetaBuilder> {
    private final String namespace;

    public AddNamespaceDecorator(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public void andThenVisit(ObjectMetaBuilder builder, ObjectMeta resourceMeta) {
        if (!builder.hasNamespace().booleanValue()) {
            builder.withNamespace(this.namespace);
        }
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, AddSidecarDecorator.class};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AddNamespaceDecorator that = (AddNamespaceDecorator)((Object)o);
        return this.namespace.equals(that.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.namespace);
    }
}

