/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.quarkus.deployment.util.DeploymentUtil;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class KubernetesConfigUtil {
    private static final String DEKORATE_PREFIX = "dekorate.";
    private static final Pattern QUARKUS_DEPLOY_PATTERN = Pattern.compile("quarkus\\.([^\\.]+)\\.deploy");

    public static Optional<String> getExplicitlyConfiguredDeploymentTarget() {
        Config config = ConfigProvider.getConfig();
        return config.getOptionalValue("quarkus.kubernetes.deployment-target", String.class);
    }

    public static List<String> getExplictilyDeploymentTargets() {
        String deploymentTargets = KubernetesConfigUtil.getExplicitlyConfiguredDeploymentTarget().orElse("");
        if (deploymentTargets.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(deploymentTargets.split(Pattern.quote(","))).map(String::trim).map(String::toLowerCase).collect(Collectors.toList());
    }

    public static Optional<String> getConfiguredDeploymentTarget() {
        Config config = ConfigProvider.getConfig();
        return KubernetesConfigUtil.getExplicitlyConfiguredDeploymentTarget().or(() -> DeploymentUtil.getEnabledDeployer());
    }

    public static List<String> getConfiguratedDeploymentTargets() {
        String deploymentTargets = KubernetesConfigUtil.getConfiguredDeploymentTarget().orElse("");
        if (deploymentTargets.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(deploymentTargets.split(",")).map(String::trim).map(String::toLowerCase).collect(Collectors.toList());
    }

    public static boolean isDeploymentEnabled() {
        return DeploymentUtil.isDeploymentEnabled((String[])new String[]{"kubernetes", "openshift", "knative", "kind", "minikube"});
    }

    public static Map<String, Object> toMap(PlatformConfiguration ... platformConfigurations) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> quarkusPrefixed = new HashMap<String, Object>();
        Arrays.stream(platformConfigurations).forEach(p -> {
            p.getPartOf().ifPresent(g -> quarkusPrefixed.put(DEKORATE_PREFIX + p.getConfigName() + ".part-of", g));
            p.getName().ifPresent(n -> quarkusPrefixed.put(DEKORATE_PREFIX + p.getConfigName() + ".name", n));
            p.getVersion().map(v -> v.equals("<<unset>>") ? "latest" : v).ifPresent(v -> quarkusPrefixed.put(DEKORATE_PREFIX + p.getConfigName() + ".version", v));
        });
        result.putAll(quarkusPrefixed);
        result.putAll(KubernetesConfigUtil.toS2iProperties(quarkusPrefixed));
        return result;
    }

    private static Map<String, Object> toS2iProperties(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        map.forEach((k, v) -> {
            if (k.contains("openshift")) {
                result.put(k.replaceAll("openshift", "s2i"), v);
            }
        });
        return result;
    }
}

