/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigMapVolumeBuilder;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.MountBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.SecretVolumeBuilder;
import io.dekorate.kubernetes.decorator.AddAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddAwsElasticBlockStoreVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddAzureDiskVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddAzureFileVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddConfigMapVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddDockerConfigJsonSecretDecorator;
import io.dekorate.kubernetes.decorator.AddEmptyDirVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddHostAliasesDecorator;
import io.dekorate.kubernetes.decorator.AddImagePullSecretDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.AddLivenessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddMetadataToTemplateDecorator;
import io.dekorate.kubernetes.decorator.AddMountDecorator;
import io.dekorate.kubernetes.decorator.AddPvcVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddReadinessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddSecretVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddSelectorToDeploymentSpecDecorator;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.AddStartupProbeDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyArgsDecorator;
import io.dekorate.kubernetes.decorator.ApplyCommandDecorator;
import io.dekorate.kubernetes.decorator.ApplyLimitsCpuDecorator;
import io.dekorate.kubernetes.decorator.ApplyLimitsMemoryDecorator;
import io.dekorate.kubernetes.decorator.ApplyRequestsCpuDecorator;
import io.dekorate.kubernetes.decorator.ApplyRequestsMemoryDecorator;
import io.dekorate.kubernetes.decorator.ApplyWorkingDirDecorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.RemoveAnnotationDecorator;
import io.dekorate.kubernetes.decorator.RemoveFromMatchingLabelsDecorator;
import io.dekorate.kubernetes.decorator.RemoveFromSelectorDecorator;
import io.dekorate.kubernetes.decorator.RemoveLabelDecorator;
import io.dekorate.project.BuildInfo;
import io.dekorate.project.FileProjectFactory;
import io.dekorate.project.Project;
import io.dekorate.project.ScmInfo;
import io.dekorate.utils.Git;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.PolicyRuleBuilder;
import io.quarkus.builder.Version;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.client.spi.KubernetesClientCapabilityBuildItem;
import io.quarkus.kubernetes.deployment.AddClusterRoleBindingResourceDecorator;
import io.quarkus.kubernetes.deployment.AddClusterRoleResourceDecorator;
import io.quarkus.kubernetes.deployment.AddNamespaceDecorator;
import io.quarkus.kubernetes.deployment.AddNamespaceToSubjectDecorator;
import io.quarkus.kubernetes.deployment.AddRoleBindingResourceDecorator;
import io.quarkus.kubernetes.deployment.AddRoleResourceDecorator;
import io.quarkus.kubernetes.deployment.AddServiceAccountResourceDecorator;
import io.quarkus.kubernetes.deployment.AddServiceMonitorResourceDecorator;
import io.quarkus.kubernetes.deployment.AddSidecarDecorator;
import io.quarkus.kubernetes.deployment.ApplyHttpGetActionPortDecorator;
import io.quarkus.kubernetes.deployment.ApplySecuritySettingsDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceAccountNameDecorator;
import io.quarkus.kubernetes.deployment.AwsElasticBlockStoreVolumeConverter;
import io.quarkus.kubernetes.deployment.AzureDiskVolumeConverter;
import io.quarkus.kubernetes.deployment.AzureFileVolumeConverter;
import io.quarkus.kubernetes.deployment.ClusterRoleBindingConfig;
import io.quarkus.kubernetes.deployment.ClusterRoleConfig;
import io.quarkus.kubernetes.deployment.ConfigMapVolumeConverter;
import io.quarkus.kubernetes.deployment.ContainerConverter;
import io.quarkus.kubernetes.deployment.CreateJobResourceFromImageDecorator;
import io.quarkus.kubernetes.deployment.EmptyDirVolumeConverter;
import io.quarkus.kubernetes.deployment.HostAliasConverter;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.MountConverter;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import io.quarkus.kubernetes.deployment.PolicyRuleConfig;
import io.quarkus.kubernetes.deployment.PortConfig;
import io.quarkus.kubernetes.deployment.PortConverter;
import io.quarkus.kubernetes.deployment.ProbeConfig;
import io.quarkus.kubernetes.deployment.ProbeConverter;
import io.quarkus.kubernetes.deployment.PropertyUtil;
import io.quarkus.kubernetes.deployment.PvcVolumeConverter;
import io.quarkus.kubernetes.deployment.RoleBindingConfig;
import io.quarkus.kubernetes.deployment.RoleConfig;
import io.quarkus.kubernetes.deployment.SecretVolumeConverter;
import io.quarkus.kubernetes.deployment.ServiceAccountConfig;
import io.quarkus.kubernetes.deployment.SubjectConfig;
import io.quarkus.kubernetes.deployment.VCSUriConfig;
import io.quarkus.kubernetes.spi.CustomProjectRootBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesClusterRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthStartupPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesInitContainerBuildItem;
import io.quarkus.kubernetes.spi.KubernetesJobBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesProbePortNameBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesServiceAccountBuildItem;
import io.quarkus.kubernetes.spi.Property;
import io.quarkus.kubernetes.spi.RoleRef;
import io.quarkus.kubernetes.spi.Subject;
import java.io.File;
import java.nio.file.Path;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class KubernetesCommonHelper {
    private static final Logger LOG = Logger.getLogger(KubernetesCommonHelper.class);
    private static final String ANY = null;
    private static final String OUTPUT_ARTIFACT_FORMAT = "%s%s.jar";
    private static final String[] PROMETHEUS_ANNOTATION_TARGETS = new String[]{"Service", "Deployment", "DeploymentConfig"};
    private static final String DEFAULT_ROLE_NAME_VIEW = "view";
    private static final List<String> LIST_WITH_EMPTY = List.of("");
    private static final String SCHEME_HTTP = "HTTP";
    private static final String SCHEME_HTTPS = "HTTPS";

    public static Optional<Project> createProject(ApplicationInfoBuildItem app, Optional<CustomProjectRootBuildItem> customProjectRoot, OutputTargetBuildItem outputTarget, PackageConfig packageConfig) {
        return KubernetesCommonHelper.createProject(app, customProjectRoot, outputTarget.getOutputDirectory().resolve(String.format(OUTPUT_ARTIFACT_FORMAT, outputTarget.getBaseName(), packageConfig.computedRunnerSuffix())));
    }

    public static Optional<Project> createProject(ApplicationInfoBuildItem app, Optional<CustomProjectRootBuildItem> customProjectRoot, Path artifactPath) {
        String name = app.getName();
        try {
            Project project = FileProjectFactory.create((File)artifactPath.toFile());
            BuildInfo buildInfo = new BuildInfo(name, app.getVersion(), "jar", project.getBuildInfo().getBuildTool(), project.getBuildInfo().getBuildToolVersion(), artifactPath.toAbsolutePath(), project.getBuildInfo().getClassOutputDir(), project.getBuildInfo().getResourceDir());
            return Optional.of(new Project(customProjectRoot.isPresent() ? customProjectRoot.get().getRoot() : project.getRoot(), buildInfo, project.getScmInfo()));
        }
        catch (Exception e) {
            LOG.debugv((Throwable)e, "Couldn't create project for {0} application", (Object)name);
            return Optional.empty();
        }
    }

    public static Optional<Port> getPort(List<KubernetesPortBuildItem> ports, KubernetesConfig config) {
        return KubernetesCommonHelper.getPort(ports, config, config.ingress.targetPort);
    }

    public static Optional<Port> getPort(List<KubernetesPortBuildItem> ports, PlatformConfiguration config, String targetPort) {
        return KubernetesCommonHelper.combinePorts(ports, config).values().stream().filter(AddServiceResourceDecorator.distinct(p -> p.getName())).filter(p -> p.getName().equals(targetPort)).findFirst();
    }

    public static Map<String, Port> combinePorts(List<KubernetesPortBuildItem> ports, PlatformConfiguration config) {
        HashMap allPorts = new HashMap();
        HashMap<String, Port> activePorts = new HashMap<String, Port>();
        allPorts.putAll(ports.stream().map(p -> ((PortBuilder)((PortBuilder)new PortBuilder().withName(p.getName())).withContainerPort(Integer.valueOf(p.getPort()))).build()).collect(Collectors.toMap(Port::getName, Function.identity(), (first, second) -> first)));
        activePorts.putAll(KubernetesCommonHelper.verifyPorts(ports).entrySet().stream().map(e -> ((PortBuilder)((PortBuilder)new PortBuilder().withName((String)e.getKey())).withContainerPort((Integer)e.getValue())).build()).collect(Collectors.toMap(Port::getName, Function.identity(), (first, second) -> first)));
        config.getPorts().entrySet().forEach(e -> {
            String name = (String)e.getKey();
            Port configuredPort = PortConverter.convert(e);
            Port buildItemPort = (Port)allPorts.get(name);
            Port combinedPort = buildItemPort == null ? configuredPort : ((PortBuilder)((PortBuilder)((PortBuilder)((PortBuilder)new PortBuilder().withName(name)).withHostPort(configuredPort.getHostPort() != null && configuredPort.getHostPort() != 0 ? configuredPort.getHostPort() : buildItemPort.getHostPort())).withContainerPort(configuredPort.getContainerPort() != null && configuredPort.getContainerPort() != 0 ? configuredPort.getContainerPort() : buildItemPort.getContainerPort())).withPath(Strings.isNotNullOrEmpty((String)configuredPort.getPath()) ? configuredPort.getPath() : buildItemPort.getPath())).build();
            activePorts.put(name, combinedPort);
        });
        return activePorts;
    }

    public static void printMessageAboutPortsThatCantChange(String target, List<KubernetesPortBuildItem> ports, PlatformConfiguration configuration) {
        ports.stream().forEach(port -> {
            boolean enabled;
            boolean bl = enabled = port.isEnabled() || configuration.getPorts().containsKey(port.getName());
            if (enabled) {
                String name = "quarkus." + target + ".ports." + port.getName() + ".container-port";
                Optional<Integer> value = Optional.ofNullable(configuration.getPorts().get(port.getName())).map(p -> p.containerPort).filter(OptionalInt::isPresent).map(OptionalInt::getAsInt);
                Property kubernetesPortProperty = new Property(name, Integer.class, value, null, false);
                PropertyUtil.printMessages(String.format("The container port %s", port.getName()), target, kubernetesPortProperty, port.getSource());
            }
        });
    }

    public static List<DecoratorBuildItem> createDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config, Optional<MetricsCapabilityBuildItem> metricsConfiguration, Optional<KubernetesClientCapabilityBuildItem> kubernetesClientConfiguration, List<KubernetesAnnotationBuildItem> annotations, List<KubernetesLabelBuildItem> labels, Optional<ContainerImageInfoBuildItem> image, Optional<KubernetesCommandBuildItem> command, Optional<Port> port, Optional<KubernetesHealthLivenessPathBuildItem> livenessProbePath, Optional<KubernetesHealthReadinessPathBuildItem> readinessProbePath, Optional<KubernetesHealthStartupPathBuildItem> startupPath, List<KubernetesRoleBuildItem> roles, List<KubernetesClusterRoleBuildItem> clusterRoles, List<KubernetesServiceAccountBuildItem> serviceAccounts, List<KubernetesRoleBindingBuildItem> roleBindings) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        result.addAll(KubernetesCommonHelper.createLabelDecorators(project, target, name, config, labels));
        result.addAll(KubernetesCommonHelper.createAnnotationDecorators(project, target, name, config, metricsConfiguration, annotations, port));
        result.addAll(KubernetesCommonHelper.createPodDecorators(project, target, name, config));
        result.addAll(KubernetesCommonHelper.createContainerDecorators(project, target, name, config));
        result.addAll(KubernetesCommonHelper.createMountAndVolumeDecorators(project, target, name, config));
        result.addAll(KubernetesCommonHelper.createAppConfigVolumeAndEnvDecorators(project, target, name, config));
        result.addAll(KubernetesCommonHelper.createCommandDecorator(project, target, name, config, command));
        result.addAll(KubernetesCommonHelper.createArgsDecorator(project, target, name, config, command));
        if (config.isGenerateImagePullSecret()) {
            image.ifPresent(i -> i.getRegistry().ifPresent(registry -> {
                if (i.getUsername().isPresent() && i.getPassword().isPresent()) {
                    String imagePullSecret = name + "-pull-secret";
                    result.add(new DecoratorBuildItem(target, (Object)new AddImagePullSecretDecorator(name, imagePullSecret)));
                    result.add(new DecoratorBuildItem(target, (Object)new AddDockerConfigJsonSecretDecorator(imagePullSecret, registry, (String)i.username.get(), (String)i.password.get())));
                }
            }));
        }
        if (!port.isEmpty()) {
            result.addAll(KubernetesCommonHelper.createProbeDecorators(name, target, config.getLivenessProbe(), config.getReadinessProbe(), config.getStartupProbe(), livenessProbePath, readinessProbePath, startupPath));
        }
        result.addAll(KubernetesCommonHelper.createRbacDecorators(name, target, config, kubernetesClientConfiguration, roles, clusterRoles, serviceAccounts, roleBindings));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<DecoratorBuildItem> createRbacDecorators(String name, String target, PlatformConfiguration config, Optional<KubernetesClientCapabilityBuildItem> kubernetesClientConfiguration, List<KubernetesRoleBuildItem> rolesFromExtensions, List<KubernetesClusterRoleBuildItem> clusterRolesFromExtensions, List<KubernetesServiceAccountBuildItem> serviceAccountsFromExtensions, List<KubernetesRoleBindingBuildItem> roleBindingsFromExtensions) {
        SubjectConfig subject;
        String subjectName;
        void var13_26;
        ArrayList<Subject> subjects;
        String rbName;
        boolean bl;
        String saName;
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        boolean kubernetesClientRequiresRbacGeneration = kubernetesClientConfiguration.map(KubernetesClientCapabilityBuildItem::isGenerateRbac).orElse(false);
        HashSet<String> roles = new HashSet<String>();
        HashSet<String> clusterRoles = new HashSet<String>();
        for (Map.Entry<String, RoleConfig> entry : config.getRbacConfig().roles.entrySet()) {
            RoleConfig role = entry.getValue();
            String string = role.name.orElse(entry.getKey());
            result.add(new DecoratorBuildItem(target, (Object)new AddRoleResourceDecorator(name, string, role.namespace.orElse(null), role.labels, KubernetesCommonHelper.toPolicyRulesList(role.policyRules))));
            roles.add(string);
        }
        for (KubernetesRoleBuildItem kubernetesRoleBuildItem : rolesFromExtensions) {
            if (kubernetesRoleBuildItem.getTarget() != null && !kubernetesRoleBuildItem.getTarget().equals(target)) continue;
            result.add(new DecoratorBuildItem(target, (Object)new AddRoleResourceDecorator(name, kubernetesRoleBuildItem.getName(), kubernetesRoleBuildItem.getNamespace(), Collections.emptyMap(), kubernetesRoleBuildItem.getRules().stream().map(it -> ((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().withApiGroups(it.getApiGroups())).withNonResourceURLs(it.getNonResourceURLs())).withResourceNames(it.getResourceNames())).withResources(it.getResources())).withVerbs(it.getVerbs())).build()).collect(Collectors.toList()))));
        }
        for (Map.Entry<String, Object> entry : config.getRbacConfig().clusterRoles.entrySet()) {
            Iterator<Map.Entry<String, ServiceAccountConfig>> clusterRole = (ClusterRoleConfig)entry.getValue();
            String string = ((ClusterRoleConfig)((Object)clusterRole)).name.orElse(entry.getKey());
            result.add(new DecoratorBuildItem(target, (Object)new AddClusterRoleResourceDecorator(name, string, ((ClusterRoleConfig)((Object)clusterRole)).labels, KubernetesCommonHelper.toPolicyRulesList(((ClusterRoleConfig)((Object)clusterRole)).policyRules))));
            clusterRoles.add(string);
        }
        for (KubernetesClusterRoleBuildItem kubernetesClusterRoleBuildItem : clusterRolesFromExtensions) {
            if (kubernetesClusterRoleBuildItem.getTarget() != null && !kubernetesClusterRoleBuildItem.getTarget().equals(target)) continue;
            result.add(new DecoratorBuildItem(target, (Object)new AddClusterRoleResourceDecorator(name, kubernetesClusterRoleBuildItem.getName(), Collections.emptyMap(), kubernetesClusterRoleBuildItem.getRules().stream().map(it -> ((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().withApiGroups(it.getApiGroups())).withNonResourceURLs(it.getNonResourceURLs())).withResourceNames(it.getResourceNames())).withResources(it.getResources())).withVerbs(it.getVerbs())).build()).collect(Collectors.toList()))));
        }
        Optional<Object> effectiveServiceAccount = Optional.empty();
        Object var13_20 = null;
        for (KubernetesServiceAccountBuildItem kubernetesServiceAccountBuildItem : serviceAccountsFromExtensions) {
            saName = Optional.ofNullable(kubernetesServiceAccountBuildItem.getName()).orElse(name);
            result.add(new DecoratorBuildItem(target, (Object)new AddServiceAccountResourceDecorator(name, saName, kubernetesServiceAccountBuildItem.getNamespace(), kubernetesServiceAccountBuildItem.getLabels())));
            if (!kubernetesServiceAccountBuildItem.isUseAsDefault() && !effectiveServiceAccount.isEmpty()) continue;
            effectiveServiceAccount = Optional.of(saName);
            String string = kubernetesServiceAccountBuildItem.getNamespace();
        }
        for (Map.Entry<String, ServiceAccountConfig> entry : config.getRbacConfig().serviceAccounts.entrySet()) {
            saName = entry.getValue().name.orElse(entry.getKey());
            result.add(new DecoratorBuildItem(target, (Object)new AddServiceAccountResourceDecorator(name, saName, entry.getValue().namespace.orElse(null), entry.getValue().labels)));
            if (!entry.getValue().isUseAsDefault() && !effectiveServiceAccount.isEmpty()) continue;
            effectiveServiceAccount = Optional.of(saName);
            String string = entry.getValue().namespace.orElse(null);
        }
        if (config.getServiceAccount().isPresent()) {
            effectiveServiceAccount = config.getServiceAccount();
            Object var13_25 = null;
        }
        String defaultRoleName = null;
        boolean bl2 = false;
        boolean requiresServiceAccount = false;
        if (!roles.isEmpty()) {
            defaultRoleName = (String)roles.iterator().next();
        } else if (!clusterRoles.isEmpty()) {
            bl = true;
            defaultRoleName = (String)clusterRoles.iterator().next();
        }
        for (KubernetesRoleBindingBuildItem kubernetesRoleBindingBuildItem : roleBindingsFromExtensions) {
            if (kubernetesRoleBindingBuildItem.getTarget() != null && !kubernetesRoleBindingBuildItem.getTarget().equals(target)) continue;
            result.add(new DecoratorBuildItem(target, (Object)new AddRoleBindingResourceDecorator(name, (String)(Strings.isNotNullOrEmpty((String)kubernetesRoleBindingBuildItem.getName()) ? kubernetesRoleBindingBuildItem.getName() : name + "-" + kubernetesRoleBindingBuildItem.getRoleRef().getName()), kubernetesRoleBindingBuildItem.getLabels(), kubernetesRoleBindingBuildItem.getRoleRef(), kubernetesRoleBindingBuildItem.getSubjects())));
        }
        for (Map.Entry entry : config.getRbacConfig().roleBindings.entrySet()) {
            rbName = ((RoleBindingConfig)entry.getValue()).name.orElse((String)entry.getKey());
            RoleBindingConfig roleBinding = (RoleBindingConfig)entry.getValue();
            subjects = new ArrayList<Subject>();
            if (roleBinding.subjects.isEmpty()) {
                requiresServiceAccount = true;
                subjects.add(new Subject(null, "ServiceAccount", (String)effectiveServiceAccount.orElse(name), (String)var13_26));
            } else {
                for (Map.Entry<String, SubjectConfig> s : roleBinding.subjects.entrySet()) {
                    subjectName = s.getValue().name.orElse(s.getKey());
                    subject = s.getValue();
                    subjects.add(new Subject((String)subject.apiGroup.orElse(null), subject.kind, subjectName, (String)subject.namespace.orElse(null)));
                }
            }
            String roleName = roleBinding.roleName.orElse(defaultRoleName);
            if (roleName == null) {
                throw new IllegalStateException("No role has been set in the RoleBinding resource!");
            }
            boolean clusterWide = roleBinding.clusterWide.orElse(bl);
            result.add(new DecoratorBuildItem(target, (Object)new AddRoleBindingResourceDecorator(name, rbName, roleBinding.labels, new RoleRef(roleName, clusterWide), subjects.toArray(new Subject[0]))));
        }
        for (Map.Entry entry : config.getRbacConfig().clusterRoleBindings.entrySet()) {
            rbName = ((ClusterRoleBindingConfig)entry.getValue()).name.orElse((String)entry.getKey());
            ClusterRoleBindingConfig clusterRoleBinding = (ClusterRoleBindingConfig)entry.getValue();
            subjects = new ArrayList();
            if (clusterRoleBinding.subjects.isEmpty()) {
                throw new IllegalStateException("No subjects have been set in the ClusterRoleBinding resource!");
            }
            for (Map.Entry<String, SubjectConfig> s : clusterRoleBinding.subjects.entrySet()) {
                subjectName = s.getValue().name.orElse(s.getKey());
                subject = s.getValue();
                subjects.add(new Subject((String)subject.apiGroup.orElse(null), subject.kind, subjectName, (String)subject.namespace.orElse(null)));
            }
            result.add(new DecoratorBuildItem(target, (Object)new AddClusterRoleBindingResourceDecorator(name, rbName, clusterRoleBinding.labels, new RoleRef(clusterRoleBinding.roleName, true), subjects.toArray(new Subject[0]))));
        }
        if (config.getRbacConfig().roleBindings.isEmpty()) {
            if (defaultRoleName != null) {
                requiresServiceAccount = true;
                result.add(new DecoratorBuildItem(target, (Object)new AddRoleBindingResourceDecorator(name, name, Collections.emptyMap(), new RoleRef(defaultRoleName, bl), new Subject(null, "ServiceAccount", (String)effectiveServiceAccount.orElse(name), (String)var13_26))));
            } else if (kubernetesClientRequiresRbacGeneration) {
                requiresServiceAccount = true;
                result.add(new DecoratorBuildItem(target, (Object)new AddRoleBindingResourceDecorator(name, name + "-view", Collections.emptyMap(), new RoleRef(DEFAULT_ROLE_NAME_VIEW, true), new Subject(null, "ServiceAccount", (String)effectiveServiceAccount.orElse(name), (String)var13_26))));
            }
        }
        if (requiresServiceAccount) {
            result.add(new DecoratorBuildItem(target, (Object)new AddServiceAccountResourceDecorator(name, (String)effectiveServiceAccount.orElse(name), (String)var13_26, Collections.emptyMap())));
        }
        if (effectiveServiceAccount.isPresent() || requiresServiceAccount) {
            result.add(new DecoratorBuildItem(target, (Object)new ApplyServiceAccountNameDecorator(name, (String)effectiveServiceAccount.orElse(name))));
        }
        return result;
    }

    private static Collection<DecoratorBuildItem> createLabelDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config, List<KubernetesLabelBuildItem> labels) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        result.add(new DecoratorBuildItem(target, (Object)new AddMetadataToTemplateDecorator()));
        result.add(new DecoratorBuildItem(target, (Object)new AddSelectorToDeploymentSpecDecorator()));
        labels.forEach(l -> result.add(new DecoratorBuildItem(l.getTarget(), (Object)new AddLabelDecorator(name, l.getKey(), l.getValue(), new String[0]))));
        if (!config.isAddVersionToLabelSelectors() || config.isIdempotent()) {
            result.add(new DecoratorBuildItem(target, (Object)new RemoveFromSelectorDecorator(name, "app.kubernetes.io/version")));
            result.add(new DecoratorBuildItem(target, (Object)new RemoveFromMatchingLabelsDecorator(name, "app.kubernetes.io/version")));
        }
        if (config.isIdempotent()) {
            result.add(new DecoratorBuildItem(target, (Object)new RemoveLabelDecorator(name, "app.kubernetes.io/version")));
        }
        if (!config.isAddNameToLabelSelectors()) {
            result.add(new DecoratorBuildItem(target, (Object)new RemoveLabelDecorator(name, "app.kubernetes.io/name")));
            result.add(new DecoratorBuildItem(target, (Object)new RemoveFromSelectorDecorator(name, "app.kubernetes.io/name")));
            result.add(new DecoratorBuildItem(target, (Object)new RemoveFromMatchingLabelsDecorator(name, "app.kubernetes.io/name")));
        }
        return result;
    }

    private static List<DecoratorBuildItem> createCommandDecorator(Optional<Project> project, String target, String name, PlatformConfiguration config, Optional<KubernetesCommandBuildItem> command) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        if (config.getCommand().isPresent()) {
            result.add(new DecoratorBuildItem(target, (Object)new ApplyCommandDecorator(name, config.getCommand().get().toArray(new String[0]))));
        } else if (command.isPresent()) {
            result.add(new DecoratorBuildItem(target, (Object)new ApplyCommandDecorator(name, command.get().getCommand().toArray(new String[0]))));
        }
        return result;
    }

    private static List<DecoratorBuildItem> createArgsDecorator(Optional<Project> project, String target, String name, PlatformConfiguration config, Optional<KubernetesCommandBuildItem> command) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        ArrayList args = new ArrayList();
        command.ifPresent(cmd -> args.addAll(cmd.getArgs()));
        config.getArguments().ifPresent(args::addAll);
        if (!args.isEmpty()) {
            result.add(new DecoratorBuildItem(target, (Object)new ApplyArgsDecorator(name, args.toArray(new String[args.size()]))));
        }
        return result;
    }

    public static List<DecoratorBuildItem> createInitContainerDecorators(String target, String name, List<KubernetesInitContainerBuildItem> items, List<DecoratorBuildItem> decorators) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        List envVarDecorators = decorators.stream().filter(d -> d.getGroup() == null || d.getGroup().equals(target)).map(d -> d.getDecorator(AddEnvVarDecorator.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List mountDecorators = decorators.stream().filter(d -> d.getGroup() == null || d.getGroup().equals(target)).map(d -> d.getDecorator(AddMountDecorator.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        items.stream().filter(item -> item.getTarget() == null || item.getTarget().equals(target)).forEach(item -> {
            io.dekorate.kubernetes.config.ContainerBuilder containerBuilder = (io.dekorate.kubernetes.config.ContainerBuilder)((io.dekorate.kubernetes.config.ContainerBuilder)((io.dekorate.kubernetes.config.ContainerBuilder)((io.dekorate.kubernetes.config.ContainerBuilder)new io.dekorate.kubernetes.config.ContainerBuilder().withName(item.getName())).withImage(item.getImage())).withCommand(item.getCommand().toArray(new String[item.getCommand().size()]))).withArguments(item.getArguments().toArray(new String[item.getArguments().size()]));
            if (item.isSharedEnvironment()) {
                for (final AddEnvVarDecorator delegate : envVarDecorators) {
                    result.add(new DecoratorBuildItem(target, (Object)new ApplicationContainerDecorator<ContainerBuilder>(name, item.getName()){

                        public void andThenVisit(ContainerBuilder builder) {
                            delegate.andThenVisit(builder);
                            for (Map.Entry e : item.getEnvVars().entrySet()) {
                                builder.removeMatchingFromEnv(p -> p.getName().equals(e.getKey()));
                                ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName((String)e.getKey())).withValue((String)e.getValue())).endEnv();
                            }
                        }
                    }));
                }
            }
            if (item.isSharedFilesystem()) {
                for (final AddEnvVarDecorator delegate : mountDecorators) {
                    result.add(new DecoratorBuildItem(target, (Object)new ApplicationContainerDecorator<ContainerBuilder>(target, item.getName(), (AddMountDecorator)delegate){
                        final /* synthetic */ AddMountDecorator val$delegate;
                        {
                            this.val$delegate = addMountDecorator;
                            super(deploymentName, containerName);
                        }

                        public void andThenVisit(ContainerBuilder builder) {
                            this.val$delegate.andThenVisit(builder);
                        }
                    }));
                }
            }
            result.add(new DecoratorBuildItem(target, (Object)new AddInitContainerDecorator(name, (Container)((io.dekorate.kubernetes.config.ContainerBuilder)containerBuilder.addAllToEnvVars((Collection)item.getEnvVars().entrySet().stream().map(e -> ((EnvBuilder)((EnvBuilder)new EnvBuilder().withName((String)e.getKey())).withValue((String)e.getValue())).build()).collect(Collectors.toList()))).build())));
        });
        return result;
    }

    public static List<DecoratorBuildItem> createInitJobDecorators(String target, String name, List<KubernetesJobBuildItem> items, List<DecoratorBuildItem> decorators) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        List envVarDecorators = decorators.stream().filter(d -> d.getGroup() == null || d.getGroup().equals(target)).map(d -> d.getDecorator(AddEnvVarDecorator.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List volumeDecorators = decorators.stream().filter(d -> d.getGroup() == null || d.getGroup().equals(target)).filter(d -> d.getDecorator() instanceof AddEmptyDirVolumeDecorator || d.getDecorator() instanceof AddSecretVolumeDecorator || d.getDecorator() instanceof AddEmptyDirVolumeDecorator || d.getDecorator() instanceof AddAzureDiskVolumeDecorator || d.getDecorator() instanceof AddAzureFileVolumeDecorator || d.getDecorator() instanceof AddAwsElasticBlockStoreVolumeDecorator).map(d -> (NamedResourceDecorator)d.getDecorator()).collect(Collectors.toList());
        List mountDecorators = decorators.stream().filter(d -> d.getGroup() == null || d.getGroup().equals(target)).map(d -> d.getDecorator(AddMountDecorator.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List imagePullSecretDecorators = decorators.stream().filter(d -> d.getGroup() == null || d.getGroup().equals(target)).map(d -> d.getDecorator(AddImagePullSecretDecorator.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List serviceAccountDecorators = decorators.stream().filter(d -> d.getGroup() == null || d.getGroup().equals(target)).map(d -> d.getDecorator(ApplyServiceAccountNameDecorator.class)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        items.stream().filter(item -> item.getTarget() == null || item.getTarget().equals(target)).forEach(item -> {
            for (final Object delegate : imagePullSecretDecorators) {
                result.add(new DecoratorBuildItem(target, (Object)new NamedResourceDecorator<PodSpecBuilder>("Job", item.getName()){

                    public void andThenVisit(PodSpecBuilder builder, ObjectMeta meta) {
                        delegate.andThenVisit((PodSpecFluent)builder, meta);
                    }
                }));
            }
            for (final Object delegate : serviceAccountDecorators) {
                result.add(new DecoratorBuildItem(target, (Object)new NamedResourceDecorator<PodSpecBuilder>("Job", item.getName(), (ApplyServiceAccountNameDecorator)((Object)((Object)delegate))){
                    final /* synthetic */ ApplyServiceAccountNameDecorator val$delegate;
                    {
                        this.val$delegate = applyServiceAccountNameDecorator;
                        super(kind, name);
                    }

                    public void andThenVisit(PodSpecBuilder builder, ObjectMeta meta) {
                        this.val$delegate.andThenVisit((PodSpecFluent)builder, meta);
                    }
                }));
            }
            result.add(new DecoratorBuildItem(target, (Object)new NamedResourceDecorator<ContainerBuilder>("Job", item.getName()){

                public void andThenVisit(ContainerBuilder builder, ObjectMeta meta) {
                    for (Map.Entry e : item.getEnvVars().entrySet()) {
                        builder.removeMatchingFromEnv(p -> p.getName().equals(e.getKey()));
                        ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName((String)e.getKey())).withValue((String)e.getValue())).endEnv();
                    }
                }
            }));
            if (item.isSharedEnvironment()) {
                for (final Object delegate : envVarDecorators) {
                    result.add(new DecoratorBuildItem(target, (Object)new NamedResourceDecorator<ContainerBuilder>("Job", item.getName(), (AddEnvVarDecorator)delegate, item){
                        final /* synthetic */ AddEnvVarDecorator val$delegate;
                        final /* synthetic */ KubernetesJobBuildItem val$item;
                        {
                            this.val$delegate = addEnvVarDecorator;
                            this.val$item = kubernetesJobBuildItem;
                            super(kind, name);
                        }

                        public void andThenVisit(ContainerBuilder builder, ObjectMeta meta) {
                            this.val$delegate.andThenVisit(builder);
                            for (Map.Entry e : this.val$item.getEnvVars().entrySet()) {
                                builder.removeMatchingFromEnv(p -> p.getName().equals(e.getKey()));
                                ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName((String)e.getKey())).withValue((String)e.getValue())).endEnv();
                            }
                        }
                    }));
                }
            }
            if (item.isSharedFilesystem()) {
                for (final Object delegate : volumeDecorators) {
                    result.add(new DecoratorBuildItem(target, (Object)new NamedResourceDecorator<PodSpecBuilder>("Job", item.getName(), (NamedResourceDecorator)delegate){
                        final /* synthetic */ NamedResourceDecorator val$delegate;
                        {
                            this.val$delegate = namedResourceDecorator;
                            super(kind, name);
                        }

                        public void andThenVisit(PodSpecBuilder builder, ObjectMeta meta) {
                            this.val$delegate.visit((VisitableBuilder)builder);
                        }
                    }));
                }
                for (final Object delegate : mountDecorators) {
                    result.add(new DecoratorBuildItem(target, (Object)new NamedResourceDecorator<ContainerBuilder>("Job", item.getName(), (AddMountDecorator)delegate){
                        final /* synthetic */ AddMountDecorator val$delegate;
                        {
                            this.val$delegate = addMountDecorator;
                            super(kind, name);
                        }

                        public void andThenVisit(ContainerBuilder builder, ObjectMeta meta) {
                            this.val$delegate.andThenVisit(builder);
                        }
                    }));
                }
            }
            result.add(new DecoratorBuildItem(target, (Object)new CreateJobResourceFromImageDecorator(item.getName(), item.getImage(), item.getCommand(), item.getArguments())));
        });
        return result;
    }

    private static List<DecoratorBuildItem> createContainerDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        if (config.getNamespace().isPresent()) {
            result.add(new DecoratorBuildItem(target, (Object)new AddNamespaceDecorator(config.getNamespace().get())));
            result.add(new DecoratorBuildItem(target, (Object)new AddNamespaceToSubjectDecorator(config.getNamespace().get())));
        }
        config.getWorkingDir().ifPresent(w -> result.add(new DecoratorBuildItem(target, (Object)new ApplyWorkingDirDecorator(name, w))));
        return result;
    }

    private static List<DecoratorBuildItem> createPodDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        config.getImagePullSecrets().ifPresent(l -> l.forEach(s -> result.add(new DecoratorBuildItem(target, (Object)new AddImagePullSecretDecorator(name, s)))));
        config.getHostAliases().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddHostAliasesDecorator(name, HostAliasConverter.convert(e)))));
        config.getInitContainers().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddInitContainerDecorator(name, ContainerConverter.convert(e)))));
        config.getSidecars().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddSidecarDecorator(name, ContainerConverter.convert(e)))));
        config.getResources().limits.cpu.ifPresent(c -> result.add(new DecoratorBuildItem(target, (Object)new ApplyLimitsCpuDecorator(name, c))));
        config.getResources().limits.memory.ifPresent(m -> result.add(new DecoratorBuildItem(target, (Object)new ApplyLimitsMemoryDecorator(name, m))));
        config.getResources().requests.cpu.ifPresent(c -> result.add(new DecoratorBuildItem(target, (Object)new ApplyRequestsCpuDecorator(name, c))));
        config.getResources().requests.memory.ifPresent(m -> result.add(new DecoratorBuildItem(target, (Object)new ApplyRequestsMemoryDecorator(name, m))));
        if (config.getSecurityContext().isAnyPropertySet()) {
            result.add(new DecoratorBuildItem(target, (Object)new ApplySecuritySettingsDecorator(name, config.getSecurityContext())));
        }
        return result;
    }

    private static List<DecoratorBuildItem> createAppConfigVolumeAndEnvDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        HashSet paths = new HashSet();
        config.getAppSecret().ifPresent(s -> {
            result.add(new DecoratorBuildItem(target, (Object)new AddSecretVolumeDecorator((SecretVolume)((SecretVolumeBuilder)((SecretVolumeBuilder)new SecretVolumeBuilder().withSecretName(s)).withVolumeName("app-secret")).build())));
            result.add(new DecoratorBuildItem(target, (Object)new AddMountDecorator((Mount)((MountBuilder)((MountBuilder)new MountBuilder().withName("app-secret")).withPath("/mnt/app-secret")).build())));
            paths.add("/mnt/app-secret");
        });
        config.getAppConfigMap().ifPresent(s -> {
            result.add(new DecoratorBuildItem(target, (Object)new AddConfigMapVolumeDecorator((ConfigMapVolume)((ConfigMapVolumeBuilder)((ConfigMapVolumeBuilder)new ConfigMapVolumeBuilder().withConfigMapName(s)).withVolumeName("app-config-map")).build())));
            result.add(new DecoratorBuildItem(target, (Object)new AddMountDecorator((Mount)((MountBuilder)((MountBuilder)new MountBuilder().withName("app-config-map")).withPath("/mnt/app-config-map")).build())));
            paths.add("/mnt/app-config-map");
        });
        if (!paths.isEmpty()) {
            result.add(new DecoratorBuildItem(target, (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, (Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName("SMALLRYE_CONFIG_LOCATIONS")).withValue(paths.stream().collect(Collectors.joining(",")))).build())));
        }
        return result;
    }

    private static List<DecoratorBuildItem> createMountAndVolumeDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        config.getMounts().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddMountDecorator(ANY, name, MountConverter.convert(e)))));
        config.getSecretVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddSecretVolumeDecorator(SecretVolumeConverter.convert(e)))));
        config.getConfigMapVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddConfigMapVolumeDecorator(ConfigMapVolumeConverter.convert(e)))));
        config.getEmptyDirVolumes().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddEmptyDirVolumeDecorator(EmptyDirVolumeConverter.convert(e)))));
        config.getPvcVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddPvcVolumeDecorator(PvcVolumeConverter.convert(e)))));
        config.getAwsElasticBlockStoreVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddAwsElasticBlockStoreVolumeDecorator(AwsElasticBlockStoreVolumeConverter.convert(e)))));
        config.getAzureFileVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddAzureFileVolumeDecorator(AzureFileVolumeConverter.convert(e)))));
        config.getAzureDiskVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddAzureDiskVolumeDecorator(AzureDiskVolumeConverter.convert(e)))));
        return result;
    }

    private static List<DecoratorBuildItem> createAnnotationDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config, Optional<MetricsCapabilityBuildItem> metricsConfiguration, List<KubernetesAnnotationBuildItem> annotations, Optional<Port> port) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        annotations.forEach(a -> result.add(new DecoratorBuildItem(a.getTarget(), (Object)new AddAnnotationDecorator(name, a.getKey(), a.getValue(), new String[0]))));
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        project.ifPresent(p -> {
            ScmInfo scm = p.getScmInfo();
            String vcsUri = KubernetesCommonHelper.parseVCSUri(config.getVCSUri(), scm);
            String commitId = scm != null ? scm.getCommit() : null;
            result.add(new DecoratorBuildItem(target, (Object)new RemoveAnnotationDecorator("app.dekorate.io/vcs-url")));
            result.add(new DecoratorBuildItem(target, (Object)new RemoveAnnotationDecorator("app.dekorate.io/commit-id")));
            result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, new Annotation("app.quarkus.io/quarkus-version", Version.getVersion(), new String[0]))));
            if (commitId != null && !config.isIdempotent()) {
                result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, new Annotation("app.quarkus.io/commit-id", commitId, new String[0]))));
            }
            if (vcsUri != null) {
                result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, new Annotation("app.quarkus.io/vcs-uri", vcsUri, new String[0]))));
            }
        });
        if (config.isAddBuildTimestamp() && !config.isIdempotent()) {
            result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, new Annotation("app.quarkus.io/build-timestamp", now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd - HH:mm:ss Z")), new String[0]))));
        }
        metricsConfiguration.ifPresent(m -> {
            String path = m.metricsEndpoint();
            String prefix = config.getPrometheusConfig().prefix;
            if (port.isPresent() && path != null) {
                if (config.getPrometheusConfig().generateServiceMonitor) {
                    result.add(new DecoratorBuildItem(target, (Object)new AddServiceMonitorResourceDecorator(config.getPrometheusConfig().scheme.orElse("http"), config.getPrometheusConfig().port.orElse(String.valueOf(((Port)port.get()).getContainerPort())), config.getPrometheusConfig().path.orElse(path), 10, true)));
                }
                if (config.getPrometheusConfig().annotations) {
                    result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, config.getPrometheusConfig().scrape.orElse(prefix + "/scrape"), "true", PROMETHEUS_ANNOTATION_TARGETS)));
                    result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, config.getPrometheusConfig().path.orElse(prefix + "/path"), path, PROMETHEUS_ANNOTATION_TARGETS)));
                    result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, config.getPrometheusConfig().port.orElse(prefix + "/port"), "" + ((Port)port.get()).getContainerPort(), PROMETHEUS_ANNOTATION_TARGETS)));
                    result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, config.getPrometheusConfig().scheme.orElse(prefix + "/scheme"), "http", PROMETHEUS_ANNOTATION_TARGETS)));
                }
            }
        });
        return result;
    }

    public static DecoratorBuildItem createProbeHttpPortDecorator(String name, String target, String probeKind, ProbeConfig probeConfig, Optional<KubernetesProbePortNameBuildItem> portName, List<KubernetesPortBuildItem> ports, Map<String, PortConfig> portsFromConfig) {
        String httpPortName = probeConfig.httpActionPortName.or(() -> portName.map(KubernetesProbePortNameBuildItem::getName)).orElse("http");
        PortConfig portFromConfig = portsFromConfig.get(httpPortName);
        Integer port = probeConfig.httpActionPort.isPresent() ? probeConfig.httpActionPort.get() : (portFromConfig != null && portFromConfig.containerPort.isPresent() ? Integer.valueOf(portFromConfig.containerPort.getAsInt()) : ports.stream().filter(p -> httpPortName.equals(p.getName())).map(KubernetesPortBuildItem::getPort).findFirst().orElse(8080));
        String scheme = probeConfig.httpActionScheme.isPresent() ? probeConfig.httpActionScheme.get() : (portFromConfig != null && portFromConfig.tls ? SCHEME_HTTPS : (portName.isPresent() && portName.get().getScheme() != null && portName.get().getName().equals(httpPortName) ? portName.get().getScheme() : (port != null && (port == 443 || port == 8443) ? SCHEME_HTTPS : SCHEME_HTTP)));
        return new DecoratorBuildItem(target, (Object)new ApplyHttpGetActionPortDecorator(ANY, name, httpPortName, port, probeKind, scheme));
    }

    private static List<DecoratorBuildItem> createProbeDecorators(String name, String target, ProbeConfig livenessProbe, ProbeConfig readinessProbe, ProbeConfig startupProbe, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath, Optional<KubernetesHealthStartupPathBuildItem> startupPath) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        KubernetesCommonHelper.createLivenessProbe(name, target, livenessProbe, livenessPath).ifPresent(d -> result.add((DecoratorBuildItem)d));
        KubernetesCommonHelper.createReadinessProbe(name, target, readinessProbe, readinessPath).ifPresent(d -> result.add((DecoratorBuildItem)d));
        if (!"knative".equals(target)) {
            KubernetesCommonHelper.createStartupProbe(name, target, startupProbe, startupPath).ifPresent(d -> result.add((DecoratorBuildItem)d));
        }
        return result;
    }

    private static Optional<DecoratorBuildItem> createLivenessProbe(String name, String target, ProbeConfig livenessProbe, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath) {
        if (livenessProbe.hasUserSuppliedAction()) {
            return Optional.of(new DecoratorBuildItem(target, (Object)new AddLivenessProbeDecorator(name, ProbeConverter.convert(name, livenessProbe))));
        }
        if (livenessPath.isPresent()) {
            return Optional.of(new DecoratorBuildItem(target, (Object)new AddLivenessProbeDecorator(name, ((ProbeBuilder)ProbeConverter.builder(name, livenessProbe).withHttpActionPath(livenessPath.get().getPath())).build())));
        }
        return Optional.empty();
    }

    private static Optional<DecoratorBuildItem> createReadinessProbe(String name, String target, ProbeConfig readinessProbe, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath) {
        if (readinessProbe.hasUserSuppliedAction()) {
            return Optional.of(new DecoratorBuildItem(target, (Object)new AddReadinessProbeDecorator(name, ProbeConverter.convert(name, readinessProbe))));
        }
        if (readinessPath.isPresent()) {
            return Optional.of(new DecoratorBuildItem(target, (Object)new AddReadinessProbeDecorator(name, ((ProbeBuilder)ProbeConverter.builder(name, readinessProbe).withHttpActionPath(readinessPath.get().getPath())).build())));
        }
        return Optional.empty();
    }

    private static Optional<DecoratorBuildItem> createStartupProbe(String name, String target, ProbeConfig startupProbe, Optional<KubernetesHealthStartupPathBuildItem> startupPath) {
        if (startupProbe.hasUserSuppliedAction()) {
            return Optional.of(new DecoratorBuildItem(target, (Object)new AddStartupProbeDecorator(name, ProbeConverter.convert(name, startupProbe))));
        }
        if (startupPath.isPresent()) {
            return Optional.of(new DecoratorBuildItem(target, (Object)new AddStartupProbeDecorator(name, ((ProbeBuilder)ProbeConverter.builder(name, startupProbe).withHttpActionPath(startupPath.get().getPath())).build())));
        }
        return Optional.empty();
    }

    private static Map<String, Integer> verifyPorts(List<KubernetesPortBuildItem> kubernetesPortBuildItems) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        HashSet<Integer> usedPorts = new HashSet<Integer>();
        for (KubernetesPortBuildItem entry : kubernetesPortBuildItems) {
            if (!entry.isEnabled()) continue;
            String name = entry.getName();
            if (result.containsKey(name)) {
                throw new IllegalArgumentException("All Kubernetes ports must have unique names - " + name + " has been used multiple times");
            }
            Integer port = entry.getPort();
            if (usedPorts.contains(port)) {
                throw new IllegalArgumentException("All Kubernetes ports must be unique - " + port + " has been used multiple times");
            }
            result.put(name, port);
            usedPorts.add(port);
        }
        return result;
    }

    private static List<PolicyRule> toPolicyRulesList(Map<String, PolicyRuleConfig> policyRules) {
        return policyRules.values().stream().map(it -> ((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().withApiGroups(it.apiGroups.orElse(LIST_WITH_EMPTY))).withNonResourceURLs((List)it.nonResourceUrls.orElse(null))).withResourceNames((List)it.resourceNames.orElse(null))).withResources((List)it.resources.orElse(null))).withVerbs((List)it.verbs.orElse(null))).build()).collect(Collectors.toList());
    }

    private static String parseVCSUri(VCSUriConfig config, ScmInfo scm) {
        if (config.enabled) {
            return config.override.orElseGet(() -> scm != null ? Git.sanitizeRemoteUrl((String)((String)scm.getRemote().get("origin"))) : null);
        }
        return null;
    }
}

