/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.EditableImageConfiguration;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.AddAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.kubernetes.decorator.ApplyReplicasToDeploymentDecorator;
import io.dekorate.openshift.decorator.ApplyReplicasToDeploymentConfigDecorator;
import io.dekorate.project.Project;
import io.dekorate.s2i.config.EditableS2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfigBuilder;
import io.dekorate.s2i.decorator.AddBuilderImageStreamResourceDecorator;
import io.dekorate.s2i.decorator.AddDockerImageStreamResourceDecorator;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.ImageUtil;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.container.spi.FallbackContainerImageRegistryBuildItem;
import io.quarkus.container.spi.ImageReference;
import io.quarkus.container.spi.SingleSegmentContainerImageRequestBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.InitTaskBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.client.spi.KubernetesClientCapabilityBuildItem;
import io.quarkus.kubernetes.deployment.AddCronJobResourceDecorator;
import io.quarkus.kubernetes.deployment.AddDeploymentResourceDecorator;
import io.quarkus.kubernetes.deployment.AddJobResourceDecorator;
import io.quarkus.kubernetes.deployment.AddNodePortDecorator;
import io.quarkus.kubernetes.deployment.AddPortToOpenshiftConfig;
import io.quarkus.kubernetes.deployment.AddStatefulSetResourceDecorator;
import io.quarkus.kubernetes.deployment.ApplyBuilderImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyContainerImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyImageGroupConfigurator;
import io.quarkus.kubernetes.deployment.ApplyImageRegistryConfigurator;
import io.quarkus.kubernetes.deployment.ApplyOpenshiftRouteConfigurator;
import io.quarkus.kubernetes.deployment.ApplyReplicasToStatefulSetDecorator;
import io.quarkus.kubernetes.deployment.ApplyResolveNamesImagePolicyDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import io.quarkus.kubernetes.deployment.ChangeContainerNameDecorator;
import io.quarkus.kubernetes.deployment.ChangeContainerNameInDeploymentTriggerDecorator;
import io.quarkus.kubernetes.deployment.ChangeDeploymentTriggerDecorator;
import io.quarkus.kubernetes.deployment.DeploymentResourceKind;
import io.quarkus.kubernetes.deployment.DisableS2iConfigurator;
import io.quarkus.kubernetes.deployment.EnableImageStreamLocalLookupPolicyDecorator;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.InitTaskProcessor;
import io.quarkus.kubernetes.deployment.KubernetesCommonHelper;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.OpenshiftConfig;
import io.quarkus.kubernetes.deployment.RemoveBuilderImageResourceDecorator;
import io.quarkus.kubernetes.deployment.RemoveDeploymentConfigResourceDecorator;
import io.quarkus.kubernetes.deployment.RemoveDeploymentTriggerDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromConfigMapEnvSourceDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromConfigMapKeySelectorDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromSecretEnvSourceDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromSecretKeySelectorDecorator;
import io.quarkus.kubernetes.deployment.RemovePortFromServiceDecorator;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.spi.ConfiguratorBuildItem;
import io.quarkus.kubernetes.spi.CustomProjectRootBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesClusterRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthStartupPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesInitContainerBuildItem;
import io.quarkus.kubernetes.spi.KubernetesJobBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesProbePortNameBuildItem;
import io.quarkus.kubernetes.spi.KubernetesResourceMetadataBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesServiceAccountBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class OpenshiftProcessor {
    private static final int OPENSHIFT_PRIORITY = 0;
    private static final String DOCKERIO_REGISTRY = "docker.io";
    private static final String OPENSHIFT_V3_APP = "app";
    private static final String ANY = null;

    @BuildStep
    public void checkOpenshift(ApplicationInfoBuildItem applicationInfo, Capabilities capabilities, OpenshiftConfig config, BuildProducer<KubernetesDeploymentTargetBuildItem> deploymentTargets, BuildProducer<KubernetesResourceMetadataBuildItem> resourceMeta) {
        List<String> targets = KubernetesConfigUtil.getConfiguredDeploymentTargets();
        boolean openshiftEnabled = targets.contains("openshift");
        DeploymentResourceKind deploymentResourceKind = config.getDeploymentResourceKind(capabilities);
        deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("openshift", deploymentResourceKind.getKind(), deploymentResourceKind.getGroup(), deploymentResourceKind.getVersion(), 0, openshiftEnabled, config.deployStrategy));
        if (openshiftEnabled) {
            String name = ResourceNameUtil.getResourceName(config, applicationInfo);
            resourceMeta.produce((BuildItem)new KubernetesResourceMetadataBuildItem("openshift", deploymentResourceKind.getGroup(), deploymentResourceKind.getVersion(), deploymentResourceKind.getKind(), name));
        }
    }

    @BuildStep
    public void populateInternalRegistry(OpenshiftConfig openshiftConfig, ContainerImageConfig containerImageConfig, Capabilities capabilities, BuildProducer<FallbackContainerImageRegistryBuildItem> containerImageRegistry, BuildProducer<SingleSegmentContainerImageRequestBuildItem> singleSegmentContainerImageRequest) {
        DeploymentResourceKind deploymentResourceKind;
        if (!containerImageConfig.registry.isPresent() && !containerImageConfig.image.isPresent() && (deploymentResourceKind = openshiftConfig.getDeploymentResourceKind(capabilities)) != DeploymentResourceKind.DeploymentConfig) {
            if (OpenshiftConfig.isOpenshiftBuildEnabled(containerImageConfig, capabilities)) {
                singleSegmentContainerImageRequest.produce((BuildItem)new SingleSegmentContainerImageRequestBuildItem());
            } else {
                containerImageRegistry.produce((BuildItem)new FallbackContainerImageRegistryBuildItem(DOCKERIO_REGISTRY));
            }
        }
    }

    @BuildStep
    public void createAnnotations(OpenshiftConfig config, BuildProducer<KubernetesAnnotationBuildItem> annotations) {
        config.getAnnotations().forEach((k, v) -> annotations.produce((BuildItem)new KubernetesAnnotationBuildItem(k, v, "openshift")));
    }

    @BuildStep
    public void createLabels(OpenshiftConfig config, BuildProducer<KubernetesLabelBuildItem> labels, BuildProducer<ContainerImageLabelBuildItem> imageLabels) {
        config.getLabels().forEach((k, v) -> {
            labels.produce((BuildItem)new KubernetesLabelBuildItem(k, v, "openshift"));
            imageLabels.produce((BuildItem)new ContainerImageLabelBuildItem(k, v));
        });
        labels.produce((BuildItem)new KubernetesLabelBuildItem("app.kubernetes.io/managed-by", "quarkus", "openshift"));
    }

    @BuildStep
    public List<ConfiguratorBuildItem> createConfigurators(ApplicationInfoBuildItem applicationInfo, OpenshiftConfig config, Capabilities capabilities, Optional<ContainerImageInfoBuildItem> image, List<KubernetesPortBuildItem> ports) {
        ArrayList<ConfiguratorBuildItem> result = new ArrayList<ConfiguratorBuildItem>();
        KubernetesCommonHelper.combinePorts(ports, config).values().forEach(value -> result.add(new ConfiguratorBuildItem((Object)new AddPortToOpenshiftConfig((Port)value))));
        result.add(new ConfiguratorBuildItem((Object)new ApplyOpenshiftRouteConfigurator(config.route)));
        if (config.remoteDebug.enabled) {
            result.add(new ConfiguratorBuildItem((Object)new AddPortToOpenshiftConfig(config.remoteDebug.buildDebugPort())));
        }
        if (!capabilities.isPresent("io.quarkus.openshift") && !capabilities.isPresent("io.quarkus.container.image.openshift")) {
            result.add(new ConfiguratorBuildItem((Object)new DisableS2iConfigurator()));
            image.flatMap(ContainerImageInfoBuildItem::getRegistry).ifPresent(r -> result.add(new ConfiguratorBuildItem((Object)new ApplyImageRegistryConfigurator((String)r))));
            image.map(ContainerImageInfoBuildItem::getGroup).ifPresent(g -> result.add(new ConfiguratorBuildItem((Object)new ApplyImageGroupConfigurator((String)g))));
        }
        return result;
    }

    @BuildStep
    public List<DecoratorBuildItem> createDecorators(ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, OpenshiftConfig config, ContainerImageConfig containerImageConfig, Optional<FallbackContainerImageRegistryBuildItem> fallbackRegistry, PackageConfig packageConfig, Optional<MetricsCapabilityBuildItem> metricsConfiguration, Optional<KubernetesClientCapabilityBuildItem> kubernetesClientConfiguration, Capabilities capabilities, List<KubernetesInitContainerBuildItem> initContainers, List<KubernetesJobBuildItem> jobs, List<KubernetesAnnotationBuildItem> annotations, List<KubernetesLabelBuildItem> labels, List<KubernetesEnvBuildItem> envs, Optional<BaseImageInfoBuildItem> baseImage, Optional<ContainerImageInfoBuildItem> image, Optional<KubernetesCommandBuildItem> command, Optional<KubernetesProbePortNameBuildItem> portName, List<KubernetesPortBuildItem> ports, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath, Optional<KubernetesHealthStartupPathBuildItem> startupPath, List<KubernetesRoleBuildItem> roles, List<KubernetesClusterRoleBuildItem> clusterRoles, List<KubernetesServiceAccountBuildItem> serviceAccounts, List<KubernetesRoleBindingBuildItem> roleBindings, Optional<CustomProjectRootBuildItem> customProjectRoot, List<KubernetesDeploymentTargetBuildItem> targets) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        if (!targets.stream().filter(KubernetesDeploymentTargetBuildItem::isEnabled).anyMatch(t -> "openshift".equals(t.getName()))) {
            return result;
        }
        String name = ResourceNameUtil.getResourceName(config, applicationInfo);
        Optional<Project> project = KubernetesCommonHelper.createProject(applicationInfo, customProjectRoot, outputTarget, packageConfig);
        Optional<Port> port = KubernetesCommonHelper.getPort(ports, config, config.route.targetPort);
        result.addAll(KubernetesCommonHelper.createDecorators(project, "openshift", name, config, metricsConfiguration, kubernetesClientConfiguration, annotations, labels, image, command, port, livenessPath, readinessPath, startupPath, roles, clusterRoles, serviceAccounts, roleBindings));
        if (config.flavor == OpenshiftConfig.OpenshiftFlavor.v3) {
            if (labels.stream().filter(l -> "openshift".equals(l.getTarget())).noneMatch(l -> l.getKey().equals(OPENSHIFT_V3_APP))) {
                result.add(new DecoratorBuildItem((Object)new AddLabelDecorator(name, OPENSHIFT_V3_APP, name, new String[0])));
            }
            result.add(new DecoratorBuildItem((Object)new RemoveOptionalFromSecretEnvSourceDecorator()));
            result.add(new DecoratorBuildItem((Object)new RemoveOptionalFromConfigMapEnvSourceDecorator()));
            result.add(new DecoratorBuildItem((Object)new RemoveOptionalFromSecretKeySelectorDecorator()));
            result.add(new DecoratorBuildItem((Object)new RemoveOptionalFromConfigMapKeySelectorDecorator()));
        }
        result.add(new DecoratorBuildItem((Object)new ApplyResolveNamesImagePolicyDecorator()));
        DeploymentResourceKind deploymentKind = config.getDeploymentResourceKind(capabilities);
        switch (deploymentKind) {
            case Deployment: {
                result.add(new DecoratorBuildItem("openshift", (Object)new RemoveDeploymentConfigResourceDecorator(name)));
                result.add(new DecoratorBuildItem("openshift", (Object)new AddDeploymentResourceDecorator(name, config)));
                break;
            }
            case StatefulSet: {
                result.add(new DecoratorBuildItem("openshift", (Object)new RemoveDeploymentConfigResourceDecorator(name)));
                result.add(new DecoratorBuildItem("openshift", (Object)new AddStatefulSetResourceDecorator(name, config)));
                break;
            }
            case Job: {
                result.add(new DecoratorBuildItem("openshift", (Object)new RemoveDeploymentConfigResourceDecorator(name)));
                result.add(new DecoratorBuildItem("openshift", (Object)new AddJobResourceDecorator(name, config.job)));
                break;
            }
            case CronJob: {
                result.add(new DecoratorBuildItem("openshift", (Object)new RemoveDeploymentConfigResourceDecorator(name)));
                result.add(new DecoratorBuildItem("openshift", (Object)new AddCronJobResourceDecorator(name, config.cronJob)));
            }
        }
        if (config.route != null) {
            for (Map.Entry<String, String> annotation : config.route.annotations.entrySet()) {
                result.add(new DecoratorBuildItem("openshift", (Object)new AddAnnotationDecorator(name, annotation.getKey(), annotation.getValue(), new String[]{"Route"})));
            }
            for (Map.Entry<String, String> label : config.route.labels.entrySet()) {
                result.add(new DecoratorBuildItem("openshift", (Object)new AddLabelDecorator(name, label.getKey(), label.getValue(), new String[]{"Route"})));
            }
        }
        if (config.getReplicas() != 1) {
            result.add(new DecoratorBuildItem("openshift", (Object)new ApplyReplicasToDeploymentConfigDecorator(name, config.getReplicas().intValue())));
            result.add(new DecoratorBuildItem("openshift", (Object)new ApplyReplicasToDeploymentDecorator(name, config.getReplicas().intValue())));
            result.add(new DecoratorBuildItem("openshift", (Object)new ApplyReplicasToStatefulSetDecorator(name, config.getReplicas())));
        }
        config.getContainerName().ifPresent(containerName -> {
            result.add(new DecoratorBuildItem("openshift", (Object)new ChangeContainerNameDecorator((String)containerName)));
            result.add(new DecoratorBuildItem("openshift", (Object)new ChangeContainerNameInDeploymentTriggerDecorator((String)containerName)));
        });
        result.add(new DecoratorBuildItem("openshift", (Object)new ApplyImagePullPolicyDecorator(name, config.getImagePullPolicy())));
        if (labels.stream().filter(l -> "openshift".equals(l.getTarget())).noneMatch(l -> l.getKey().equals("app.openshift.io/runtime"))) {
            result.add(new DecoratorBuildItem("openshift", (Object)new AddLabelDecorator(name, "app.openshift.io/runtime", "quarkus", new String[0])));
        }
        Stream.concat(config.convertToBuildItems().stream(), envs.stream().filter(e -> e.getTarget() == null || "openshift".equals(e.getTarget()))).forEach(e -> result.add(new DecoratorBuildItem("openshift", (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, (Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(e.getName()))).withValue(e.getValue())).withSecret(e.getSecret())).withConfigmap(e.getConfigMap())).withField(e.getField())).build()))));
        result.add(new DecoratorBuildItem("openshift", (Object)new EnableImageStreamLocalLookupPolicyDecorator()));
        baseImage.map(BaseImageInfoBuildItem::getImage).ifPresent(builderImage -> {
            block7: {
                block6: {
                    String builderImageName = ImageUtil.getName((String)builderImage);
                    if (!"s2i-java".equals(builderImageName)) {
                        result.add(new DecoratorBuildItem("openshift", (Object)new RemoveBuilderImageResourceDecorator("s2i-java")));
                    }
                    if (containerImageConfig.builder.isEmpty()) break block6;
                    if (!OpenshiftConfig.isOpenshiftBuildEnabled(containerImageConfig, capabilities)) break block7;
                }
                result.add(new DecoratorBuildItem("openshift", (Object)new ApplyBuilderImageDecorator(name, (String)builderImage)));
                ImageReference imageRef = ImageReference.parse((String)builderImage);
                boolean usesInternalRegistry = imageRef.getRegistry().filter(registry -> registry.contains("openshift-image-registry")).isPresent();
                if (usesInternalRegistry) {
                    String repository = imageRef.getRepository();
                    String imageStreamName = repository.substring(repository.lastIndexOf("/"));
                    result.add(new DecoratorBuildItem("openshift", (Object)new RemoveBuilderImageResourceDecorator(imageStreamName)));
                } else {
                    EditableS2iBuildConfig s2iBuildConfig = ((S2iBuildConfigBuilder)new S2iBuildConfigBuilder().withBuilderImage(builderImage)).build();
                    result.add(new DecoratorBuildItem("openshift", (Object)new AddBuilderImageStreamResourceDecorator((S2iBuildConfig)s2iBuildConfig)));
                }
            }
        });
        result.add(new DecoratorBuildItem("openshift", (Object)new ApplyServiceTypeDecorator(name, config.getServiceType().name())));
        if (config.getServiceType() == ServiceType.NodePort && config.nodePort.isPresent()) {
            result.add(new DecoratorBuildItem("openshift", (Object)new AddNodePortDecorator(name, config.nodePort.getAsInt(), config.route.targetPort)));
        }
        result.add(KubernetesCommonHelper.createProbeHttpPortDecorator(name, "openshift", "livenessProbe", config.livenessProbe, portName, ports, config.ports));
        result.add(KubernetesCommonHelper.createProbeHttpPortDecorator(name, "openshift", "readinessProbe", config.readinessProbe, portName, ports, config.ports));
        result.add(KubernetesCommonHelper.createProbeHttpPortDecorator(name, "openshift", "startupProbe", config.startupProbe, portName, ports, config.ports));
        image.ifPresent(i -> {
            String registry = i.registry.or(() -> containerImageConfig.registry).orElse(fallbackRegistry.map(f -> f.getRegistry()).orElse(DOCKERIO_REGISTRY));
            String repositoryWithRegistry = registry + "/" + i.getRepository();
            EditableImageConfiguration imageConfiguration = ((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withName(name)).withRegistry(registry)).build();
            String imageStreamWithTag = name + ":" + i.getTag();
            if (deploymentKind == DeploymentResourceKind.DeploymentConfig && !OpenshiftConfig.isOpenshiftBuildEnabled(containerImageConfig, capabilities)) {
                result.add(new DecoratorBuildItem("openshift", (Object)new AddDockerImageStreamResourceDecorator((ImageConfiguration)imageConfiguration, repositoryWithRegistry)));
            }
            result.add(new DecoratorBuildItem("openshift", (Object)new ApplyContainerImageDecorator(name, i.getImage())));
            result.add(new DecoratorBuildItem("openshift", (Object)new RemoveDeploymentTriggerDecorator(name)));
            result.add(new DecoratorBuildItem("openshift", (Object)new ChangeDeploymentTriggerDecorator(name, imageStreamWithTag)));
        });
        if (config.remoteDebug.enabled) {
            result.add(new DecoratorBuildItem("openshift", (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, config.remoteDebug.buildJavaToolOptionsEnv())));
        }
        result.addAll(KubernetesCommonHelper.createInitContainerDecorators("openshift", name, initContainers, result));
        result.addAll(KubernetesCommonHelper.createInitJobDecorators("openshift", name, jobs, result));
        if (!(!KubernetesConfigUtil.managementPortIsEnabled() || config.route != null && config.route.expose && config.route.targetPort.equals("management"))) {
            result.add(new DecoratorBuildItem("openshift", (Object)new RemovePortFromServiceDecorator(name, "management")));
        }
        KubernetesCommonHelper.printMessageAboutPortsThatCantChange("openshift", ports, config);
        return result;
    }

    @BuildStep
    void externalizeInitTasks(ApplicationInfoBuildItem applicationInfo, OpenshiftConfig config, ContainerImageInfoBuildItem image, List<InitTaskBuildItem> initTasks, BuildProducer<KubernetesJobBuildItem> jobs, BuildProducer<KubernetesInitContainerBuildItem> initContainers, BuildProducer<KubernetesEnvBuildItem> env, BuildProducer<KubernetesRoleBuildItem> roles, BuildProducer<KubernetesRoleBindingBuildItem> roleBindings, BuildProducer<KubernetesServiceAccountBuildItem> serviceAccount, BuildProducer<DecoratorBuildItem> decorators) {
        String name = ResourceNameUtil.getResourceName(config, applicationInfo);
        if (config.externalizeInit) {
            InitTaskProcessor.process("openshift", name, image, initTasks, config.initTaskDefaults, config.initTasks, jobs, initContainers, env, roles, roleBindings, serviceAccount, decorators);
        }
    }
}

