/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.processor.SimpleFileWriter;
import io.dekorate.project.Project;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class QuarkusFileWriter
extends SimpleFileWriter {
    private static final List<String> RESOURCE_KIND_ORDER = List.of("Namespace", "NetworkPolicy", "ResourceQuota", "LimitRange", "PodSecurityPolicy", "PodDisruptionBudget", "ServiceAccount", "Secret", "SecretList", "ConfigMap", "StorageClass", "PersistentVolume", "PersistentVolumeClaim", "CustomResourceDefinition", "ClusterRole", "ClusterRoleList", "ClusterRoleBinding", "ClusterRoleBindingList", "Role", "RoleList", "RoleBinding", "RoleBindingList", "Service", "ImageStream", "BuildConfig", "DaemonSet", "Pod", "ReplicationController", "ReplicaSet", "Deployment", "HorizontalPodAutoscaler", "StatefulSet", "DeploymentConfig", "Job", "CronJob", "Ingress", "Route", "APIService");

    public QuarkusFileWriter(Project project) {
        super(project, false);
    }

    public Map<String, String> write(String group, KubernetesList list) {
        return super.write(group, ((KubernetesListBuilder)new KubernetesListBuilder().addAllToItems(this.sort(list.getItems()))).build());
    }

    private List<HasMetadata> sort(List<HasMetadata> items) {
        HashMap<String, List> groups = new HashMap<String, List>();
        LinkedList<HasMetadata> rest = new LinkedList<HasMetadata>();
        for (HasMetadata item : items) {
            String kind = item.getKind();
            if (RESOURCE_KIND_ORDER.contains(kind)) {
                groups.computeIfAbsent(kind, k -> new LinkedList()).add(item);
                continue;
            }
            rest.add(item);
        }
        LinkedList<HasMetadata> sorted = new LinkedList<HasMetadata>();
        for (String kind : RESOURCE_KIND_ORDER) {
            List group = (List)groups.get(kind);
            if (group == null) continue;
            sorted.addAll(group);
        }
        sorted.addAll(rest);
        return sorted;
    }
}

