/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.quarkus.kubernetes.deployment.EnvConfig;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.EnvVarPrefixConfig;
import io.quarkus.kubernetes.deployment.EnvVarValidator;
import io.quarkus.kubernetes.deployment.EnvVarsConfig;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public interface EnvVarHolder {
    public EnvVarsConfig getEnv();

    @Deprecated
    public Map<String, EnvConfig> getEnvVars();

    public String getTargetPlatformName();

    default public Collection<KubernetesEnvBuildItem> convertToBuildItems() {
        EnvVarValidator validator = new EnvVarValidator();
        String target = this.getTargetPlatformName();
        this.getEnvVars().forEach((key, envConfig) -> validator.process((String)key, envConfig.value, envConfig.secret, envConfig.configmap, envConfig.field, target, Optional.empty(), true));
        EnvVarsConfig c = this.getEnv();
        Map<String, EnvVarPrefixConfig> prefixMap = EnvConverter.collectPrefixes(c);
        c.vars.forEach((k, v) -> validator.process(KubernetesEnvBuildItem.createSimpleVar((String)k, (String)v.orElse(""), (String)target, (boolean[])new boolean[0])));
        c.fields.forEach((k, v) -> validator.process(KubernetesEnvBuildItem.createFromField((String)k, (String)v, (String)target, (boolean[])new boolean[0])));
        c.configmaps.ifPresent(cl -> cl.forEach(cm -> validator.process(KubernetesEnvBuildItem.createFromConfigMap((String)cm, (String)target, (String)EnvConverter.extractConfigmapPrefix(cm, prefixMap).orElse(null), (boolean[])new boolean[0]))));
        c.secrets.ifPresent(sl -> sl.forEach(s -> validator.process(KubernetesEnvBuildItem.createFromSecret((String)s, (String)target, (String)EnvConverter.extractSecretPrefix(s, prefixMap).orElse(null), (boolean[])new boolean[0]))));
        c.mapping.forEach((varName, config) -> validator.process(KubernetesEnvBuildItem.createFromResourceKey((String)varName, (String)config.withKey, (String)config.fromSecret.orElse(null), (String)config.fromConfigmap.orElse(null), (String)target, (boolean[])new boolean[0])));
        return validator.getBuildItems();
    }
}

