/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class EnvVarValidator {
    private static final Logger log = Logger.getLogger(EnvVarValidator.class);
    private final Map<ItemKey, KubernetesEnvBuildItem> items = new HashMap<ItemKey, KubernetesEnvBuildItem>();
    private final Set<String> knownNames = new HashSet<String>();
    private final Map<String, Set<KubernetesEnvBuildItem>> conflicting = new HashMap<String, Set<KubernetesEnvBuildItem>>();
    private final Set<String> errors = new HashSet<String>();

    void process(String name, Optional<String> value, Optional<String> secret, Optional<String> configmap, Optional<String> field, String target, Optional<String> prefix, boolean ... oldStyle) {
        try {
            KubernetesEnvBuildItem kebi = KubernetesEnvBuildItem.create((String)name, (String)value.orElse(null), (String)secret.orElse(null), (String)configmap.orElse(null), (String)field.orElse(null), (String)target, (String)prefix.orElse(null), (boolean[])oldStyle);
            this.process(kebi);
        }
        catch (IllegalArgumentException e) {
            this.errors.add(e.getMessage());
        }
    }

    void process(KubernetesEnvBuildItem item) {
        String name = item.getName();
        ShouldAddHolder wrapper = new ShouldAddHolder();
        if (this.knownNames.contains(name)) {
            KubernetesEnvBuildItem.EnvType type = item.getType();
            wrapper.setShouldAdd(false);
            this.items.values().stream().filter(kebi -> name.equals(kebi.getName())).forEach(existing -> {
                KubernetesEnvBuildItem.EnvType existingType = existing.getType();
                if (!existingType.allowMultipleDefinitions) {
                    if (existingType.mightConflictWith(type)) {
                        boolean existingIsNew;
                        boolean currentIsNew = existing.isOldStyle() && !item.isOldStyle();
                        boolean bl = existingIsNew = item.isOldStyle() && !existing.isOldStyle();
                        if ((currentIsNew || existingIsNew) && existingType.equals((Object)type)) {
                            log.warn((Object)("Duplicate definition of '" + name + "' environment variable. ONLY the quarkus.kubernetes.env prefixed version will be kept: " + (currentIsNew ? item : existing)));
                            if (currentIsNew) {
                                wrapper.setShouldAdd(true);
                            }
                        } else {
                            this.addError(item, (KubernetesEnvBuildItem)existing);
                        }
                    } else {
                        wrapper.setShouldAdd(true);
                    }
                } else {
                    if (existingType.mightConflictWith(type)) {
                        log.warn((Object)("Ignoring duplicate definition of " + item));
                    }
                    wrapper.setShouldAdd(true);
                }
            });
        }
        if (wrapper.shouldAdd()) {
            this.items.put(ItemKey.keyFor(item), item);
        }
        this.knownNames.add(name);
    }

    private void addError(KubernetesEnvBuildItem item, KubernetesEnvBuildItem existing) {
        Set inError = this.conflicting.computeIfAbsent(item.getName(), k -> new LinkedHashSet());
        inError.add(existing);
        inError.add(item);
    }

    Collection<KubernetesEnvBuildItem> getBuildItems() {
        if (this.conflicting.isEmpty() && this.errors.isEmpty()) {
            return this.items.values();
        }
        throw new IllegalArgumentException(this.getError());
    }

    private String getError() {
        Object error = "\n";
        if (!this.conflicting.isEmpty()) {
            error = (String)error + "\t+ Conflicts in environment variable definitions:\n";
            error = (String)error + this.conflicting.entrySet().stream().map(e -> {
                String conflicting = ((Set)e.getValue()).stream().map(Object::toString).collect(Collectors.joining(" redefined as "));
                return String.format("\t\t- '%s': first defined as %s", e.getKey(), conflicting);
            }).collect(Collectors.joining("\n"));
        }
        if (!this.errors.isEmpty()) {
            error = (String)error + "\t+ Invalid declarations:\n";
            error = (String)error + this.errors.stream().map(s -> "\t\t- " + s).collect(Collectors.joining("\n"));
        }
        return error;
    }

    private static final class ShouldAddHolder {
        private boolean shouldAdd = true;

        ShouldAddHolder() {
        }

        public boolean shouldAdd() {
            return this.shouldAdd;
        }

        public void setShouldAdd(boolean shouldAdd) {
            this.shouldAdd = shouldAdd;
        }
    }

    private static final class ItemKey {
        private final KubernetesEnvBuildItem.EnvType type;
        private final String name;

        ItemKey(KubernetesEnvBuildItem.EnvType type, String name) {
            this.type = type;
            this.name = name;
        }

        public static ItemKey keyFor(KubernetesEnvBuildItem item) {
            return new ItemKey(item.getType(), item.getName());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemKey itemKey = (ItemKey)o;
            if (this.type != itemKey.type) {
                return false;
            }
            return this.name.equals(itemKey.name);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

