/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.quarkus.kubernetes.deployment.ProbeConfig;
import org.eclipse.microprofile.config.ConfigProvider;

public class ProbeConverter {
    public static Probe convert(String name, ProbeConfig probe) {
        return ProbeConverter.builder(name, probe).build();
    }

    public static ProbeBuilder builder(String name, ProbeConfig probe) {
        ProbeBuilder b = new ProbeBuilder();
        probe.httpActionPath().ifPresent(arg_0 -> ((ProbeBuilder)b).withHttpActionPath(arg_0));
        probe.execAction().ifPresent(arg_0 -> ((ProbeBuilder)b).withExecAction(arg_0));
        probe.tcpSocketAction().ifPresent(arg_0 -> ((ProbeBuilder)b).withTcpSocketAction(arg_0));
        if (probe.grpcAction().isPresent()) {
            b.withGrpcAction(probe.grpcAction().get());
        } else if (probe.grpcActionEnabled()) {
            b.withGrpcAction(ProbeConverter.getQuarkusGrpcPort() + ":" + name);
        }
        b.withInitialDelaySeconds(Integer.valueOf((int)probe.initialDelay().getSeconds()));
        b.withPeriodSeconds(Integer.valueOf((int)probe.period().getSeconds()));
        b.withTimeoutSeconds(Integer.valueOf((int)probe.timeout().getSeconds()));
        b.withSuccessThreshold(probe.successThreshold());
        b.withFailureThreshold(probe.failureThreshold());
        return b;
    }

    private static int getQuarkusGrpcPort() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.grpc.server.port", Integer.class).orElse(9000);
    }
}

