/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.quarkus.deployment.Capabilities;
import io.quarkus.kubernetes.deployment.CronJobConfig;
import io.quarkus.kubernetes.deployment.DebugConfig;
import io.quarkus.kubernetes.deployment.DeploymentResourceKind;
import io.quarkus.kubernetes.deployment.IngressConfig;
import io.quarkus.kubernetes.deployment.InitTaskConfig;
import io.quarkus.kubernetes.deployment.JobConfig;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import io.quarkus.kubernetes.deployment.RollingUpdateConfig;
import io.quarkus.kubernetes.spi.DeployStrategy;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigMapping(prefix="quarkus.kubernetes")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface KubernetesConfig
extends PlatformConfiguration {
    @Override
    default public String targetPlatformName() {
        return "kubernetes";
    }

    public Optional<DeploymentResourceKind> deploymentKind();

    public Optional<List<String>> deploymentTarget();

    @WithDefault(value="None")
    public DeploymentStrategy strategy();

    public RollingUpdateConfig rollingUpdate();

    @WithDefault(value="1")
    public Integer replicas();

    public OptionalInt nodePort();

    public IngressConfig ingress();

    public JobConfig job();

    public CronJobConfig cronJob();

    public DebugConfig remoteDebug();

    @Deprecated(since="3.1", forRemoval=true)
    @WithDefault(value="true")
    public boolean externalizeInit();

    public Map<String, InitTaskConfig> initTasks();

    public InitTaskConfig initTaskDefaults();

    public Optional<String> outputDirectory();

    @WithDefault(value="false")
    public boolean deploy();

    @WithDefault(value="CreateOrUpdate")
    public DeployStrategy deployStrategy();

    default public DeploymentResourceKind getDeploymentResourceKind(Capabilities capabilities) {
        if (this.deploymentKind().isPresent()) {
            return this.deploymentKind().filter(k -> k.isAvailalbleOn("kubernetes")).get();
        }
        if (capabilities.isPresent("io.quarkus.picocli")) {
            return DeploymentResourceKind.Job;
        }
        return DeploymentResourceKind.Deployment;
    }
}

