/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.smallrye.config.WithDefault;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface RbacConfig {
    public Map<String, RoleConfig> roles();

    public Map<String, ClusterRoleConfig> clusterRoles();

    public Map<String, ServiceAccountConfig> serviceAccounts();

    public Map<String, RoleBindingConfig> roleBindings();

    public Map<String, ClusterRoleBindingConfig> clusterRoleBindings();

    public static interface SubjectConfig {
        public Optional<String> name();

        @WithDefault(value="ServiceAccount")
        public String kind();

        public Optional<String> apiGroup();

        public Optional<String> namespace();
    }

    public static interface PolicyRuleConfig {
        public Optional<List<String>> apiGroups();

        public Optional<List<String>> nonResourceUrls();

        public Optional<List<String>> resourceNames();

        public Optional<List<String>> resources();

        public Optional<List<String>> verbs();
    }

    public static interface ClusterRoleBindingConfig {
        public Optional<String> name();

        @ConfigDocMapKey(value="label-name")
        public Map<String, String> labels();

        public String roleName();

        public Map<String, SubjectConfig> subjects();
    }

    public static interface RoleBindingConfig {
        public Optional<String> name();

        @ConfigDocMapKey(value="label-name")
        public Map<String, String> labels();

        public Optional<String> roleName();

        public Optional<Boolean> clusterWide();

        public Map<String, SubjectConfig> subjects();
    }

    public static interface ServiceAccountConfig {
        public Optional<String> name();

        public Optional<String> namespace();

        @ConfigDocMapKey(value="label-name")
        public Map<String, String> labels();

        public Optional<Boolean> useAsDefault();

        default public boolean isUseAsDefault() {
            return this.useAsDefault().orElse(false);
        }
    }

    public static interface ClusterRoleConfig {
        public Optional<String> name();

        @ConfigDocMapKey(value="label-name")
        public Map<String, String> labels();

        public Map<String, PolicyRuleConfig> policyRules();
    }

    public static interface RoleConfig {
        public Optional<String> name();

        public Optional<String> namespace();

        @ConfigDocMapKey(value="label-name")
        public Map<String, String> labels();

        public Map<String, PolicyRuleConfig> policyRules();
    }
}

