/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.fabric8.knative.client.KnativeClient;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.kubernetes.client.spi.KubernetesClientBuildItem;
import io.quarkus.kubernetes.deployment.KubernetesDeploy;
import io.quarkus.kubernetes.deployment.SelectedKubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentClusterBuildItem;
import java.util.List;
import java.util.Optional;

public class KnativeDeployer {
    @BuildStep
    public void checkEnvironment(Optional<SelectedKubernetesDeploymentTargetBuildItem> selectedDeploymentTarget, List<GeneratedKubernetesResourceBuildItem> resources, KubernetesClientBuildItem kubernetesClientBuilder, BuildProducer<KubernetesDeploymentClusterBuildItem> deploymentCluster) {
        selectedDeploymentTarget.ifPresent(target -> {
            block9: {
                if (!KubernetesDeploy.INSTANCE.checkSilently(kubernetesClientBuilder)) {
                    return;
                }
                if (target.getEntry().getName().equals("knative")) {
                    try (KnativeClient client = (KnativeClient)kubernetesClientBuilder.buildClient().adapt(KnativeClient.class);){
                        if (client.hasApiGroup("knative.dev", false)) {
                            deploymentCluster.produce((BuildItem)new KubernetesDeploymentClusterBuildItem("knative"));
                            break block9;
                        }
                        throw new IllegalStateException("Knative was requested as a deployment, but the target cluster is not a Knative cluster!");
                    }
                }
            }
        });
    }
}

