/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.quarkus.deployment.util.DeploymentUtil;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class KubernetesConfigUtil {
    public static final String MANAGEMENT_PORT_NAME = "management";
    private static final String DEKORATE_PREFIX = "dekorate.";

    public static Optional<String> getExplicitlyConfiguredDeploymentTarget() {
        Config config = ConfigProvider.getConfig();
        return config.getOptionalValue("quarkus.kubernetes.deployment-target", String.class);
    }

    @Deprecated(forRemoval=true)
    public static List<String> getExplictilyDeploymentTargets() {
        return KubernetesConfigUtil.getExplicitlyConfiguredDeploymentTargets();
    }

    public static List<String> getExplicitlyConfiguredDeploymentTargets() {
        return KubernetesConfigUtil.splitDeploymentTargets(KubernetesConfigUtil.getExplicitlyConfiguredDeploymentTarget());
    }

    private static List<String> splitDeploymentTargets(Optional<String> commaSeparatedDeploymentTargets) {
        return commaSeparatedDeploymentTargets.map(s -> Arrays.stream(s.split(",")).map(String::trim).map(String::toLowerCase).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static Optional<String> getConfiguredDeploymentTarget() {
        return KubernetesConfigUtil.getExplicitlyConfiguredDeploymentTarget().or(DeploymentUtil::getEnabledDeployer);
    }

    @Deprecated(forRemoval=true)
    public static List<String> getConfiguratedDeploymentTargets() {
        return KubernetesConfigUtil.getConfiguredDeploymentTargets();
    }

    public static List<String> getConfiguredDeploymentTargets() {
        return KubernetesConfigUtil.splitDeploymentTargets(KubernetesConfigUtil.getConfiguredDeploymentTarget());
    }

    public static boolean isDeploymentEnabled() {
        return DeploymentUtil.isDeploymentEnabled((String[])new String[]{"kubernetes", "openshift", "knative", "kind", "minikube"});
    }

    public static Map<String, Object> toMap(PlatformConfiguration ... platformConfigurations) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> quarkusPrefixed = new HashMap<String, Object>();
        Arrays.stream(platformConfigurations).forEach(p -> {
            p.getPartOf().ifPresent(g -> quarkusPrefixed.put(DEKORATE_PREFIX + p.getConfigName() + ".part-of", g));
            p.getName().ifPresent(n -> quarkusPrefixed.put(DEKORATE_PREFIX + p.getConfigName() + ".name", n));
            p.getVersion().map(v -> v.equals("<<unset>>") ? "latest" : v).ifPresent(v -> quarkusPrefixed.put(DEKORATE_PREFIX + p.getConfigName() + ".version", v));
        });
        result.putAll(quarkusPrefixed);
        result.putAll(KubernetesConfigUtil.toS2iProperties(quarkusPrefixed));
        return result;
    }

    public static boolean managementPortIsEnabled() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.management.enabled", Boolean.class).orElse(false);
    }

    private static Map<String, Object> toS2iProperties(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        map.forEach((k, v) -> {
            if (k.contains("openshift")) {
                result.put(k.replaceAll("openshift", "s2i"), v);
            }
        });
        return result;
    }
}

