/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.service.binding.buildtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.util.Optional;

@ConfigGroup
public class ServiceConfig {
    @ConfigItem
    public Optional<String> binding;
    @ConfigItem
    public Optional<String> kind;
    @ConfigItem
    public Optional<String> apiVersion;
    @ConfigItem
    public Optional<String> name;
    @ConfigItem
    public Optional<String> namespace;

    protected static ServiceConfig createNew() {
        ServiceConfig config = new ServiceConfig();
        config.binding = Optional.empty();
        config.apiVersion = Optional.empty();
        config.kind = Optional.empty();
        config.name = Optional.empty();
        config.namespace = Optional.empty();
        return config;
    }

    protected ServiceConfig withBinding(String binding) {
        this.binding = Optional.of(binding);
        return this;
    }

    protected ServiceConfig withApiVersion(String apiVersion) {
        this.apiVersion = Optional.of(apiVersion);
        return this;
    }

    protected ServiceConfig withKind(String kind) {
        this.kind = Optional.of(kind);
        return this;
    }

    protected ServiceConfig withName(String name) {
        this.name = Optional.of(name);
        return this;
    }
}

