/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.service.binding.buildtime;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.servicebinding.model.ServiceBindingBuilder;
import io.dekorate.servicebinding.model.ServiceBindingFluent;
import io.dekorate.servicebinding.model.ServiceBindingSpecBuilder;
import io.dekorate.servicebinding.model.ServiceBindingSpecFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListFluent;
import io.quarkus.kubernetes.service.binding.buildtime.KubernetesServiceBindingBuildItem;
import io.quarkus.kubernetes.service.binding.buildtime.KubernetesServiceBindingConfig;
import java.util.List;
import java.util.Optional;

public class AddServiceBindingResourceDecorator
extends ResourceProvidingDecorator<KubernetesListFluent<?>> {
    private final String group;
    private final String version;
    private final String kind;
    private final String name;
    private final KubernetesServiceBindingConfig config;
    private final List<KubernetesServiceBindingBuildItem> services;

    public AddServiceBindingResourceDecorator(String group, String version, String kind, String name, KubernetesServiceBindingConfig config, List<KubernetesServiceBindingBuildItem> services) {
        this.group = group;
        this.version = version;
        this.kind = kind;
        this.name = name;
        this.config = config;
        this.services = services;
    }

    public void visit(KubernetesListFluent<?> list) {
        if (this.services.isEmpty()) {
            return;
        }
        ServiceBindingSpecBuilder spec = new ServiceBindingSpecBuilder();
        ((ServiceBindingSpecBuilder)((ServiceBindingSpecBuilder)((ServiceBindingSpecFluent.ApplicationNested)((ServiceBindingSpecFluent.ApplicationNested)((ServiceBindingSpecFluent.ApplicationNested)((ServiceBindingSpecFluent.ApplicationNested)spec.withNewApplication().withGroup(this.group)).withVersion(this.version)).withKind(this.kind)).withName(this.name)).endApplication()).withBindAsFiles(this.config.bindAsFiles.booleanValue())).withMountPath((String)this.config.mountPath.orElse(null));
        for (KubernetesServiceBindingBuildItem service : this.services) {
            String group = service.getApiVersion().contains("/") ? (String)Optional.ofNullable(service.getApiVersion()).map(a -> a.split("/")[0]).orElse(null) : "";
            String version = service.getApiVersion().contains("/") ? (String)Optional.ofNullable(service.getApiVersion()).map(a -> a.split("/")[1]).orElse(null) : service.getApiVersion();
            spec = (ServiceBindingSpecBuilder)((ServiceBindingSpecFluent.ServicesNested)((ServiceBindingSpecFluent.ServicesNested)((ServiceBindingSpecFluent.ServicesNested)((ServiceBindingSpecFluent.ServicesNested)spec.addNewService().withGroup(group)).withVersion(version)).withKind(service.getKind())).withName(service.getName())).endService();
        }
        ServiceBindingBuilder binding = (ServiceBindingBuilder)((ServiceBindingBuilder)((ServiceBindingFluent.MetadataNested)new ServiceBindingBuilder().withNewMetadata().withName(this.name)).endMetadata()).withSpec(spec.build());
        list.addToItems(new HasMetadata[]{binding.build()});
    }
}

