/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.service.binding.buildtime;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.kubernetes.service.binding.buildtime.AddServiceBindingResourceDecorator;
import io.quarkus.kubernetes.service.binding.buildtime.KubernetesServiceBindingBuildItem;
import io.quarkus.kubernetes.service.binding.buildtime.KubernetesServiceBindingConfig;
import io.quarkus.kubernetes.service.binding.buildtime.ServiceConfig;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesResourceMetadataBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ServiceBindingProcessor {
    @BuildStep
    public List<KubernetesServiceBindingBuildItem> createServiceBindingDecorators(KubernetesServiceBindingConfig serviceBindingConfig) {
        return serviceBindingConfig.services.entrySet().stream().map(e -> new KubernetesServiceBindingBuildItem(((ServiceConfig)e.getValue()).apiVersion, ((ServiceConfig)e.getValue()).kind, ((ServiceConfig)e.getValue()).name.orElse((String)e.getKey()))).collect(Collectors.toList());
    }

    @BuildStep
    public List<DecoratorBuildItem> createServiceBindingDecorators(KubernetesServiceBindingConfig serviceBindingConfig, List<KubernetesServiceBindingBuildItem> services, List<KubernetesResourceMetadataBuildItem> resources) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        resources.stream().distinct().forEach(r -> {
            if (!serviceBindingConfig.services.isEmpty()) {
                result.add(new DecoratorBuildItem(r.getTarget(), (Object)new AddServiceBindingResourceDecorator(r.getGroup(), r.getVersion(), r.getKind(), r.getName(), serviceBindingConfig, services)));
            }
        });
        return result;
    }
}

