/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.service.binding.buildtime;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.kubernetes.service.binding.buildtime.AddServiceBindingResourceDecorator;
import io.quarkus.kubernetes.service.binding.buildtime.KubernetesServiceBindingConfig;
import io.quarkus.kubernetes.service.binding.buildtime.ServiceConfig;
import io.quarkus.kubernetes.service.binding.spi.ServiceBindingQualifierBuildItem;
import io.quarkus.kubernetes.service.binding.spi.ServiceBindingRequirementBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesOptionalResourceDefinitionBuildItem;
import io.quarkus.kubernetes.spi.KubernetesResourceMetadataBuildItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ServiceBindingProcessor {
    protected static final Map<String, String> DEFAULTS = new HashMap<String, String>();
    private static final String KIND = "ServiceBinding";
    private static final String API_VERSION = "binding.operators.coreos.com/v1alpha1";

    @BuildStep
    public void registerServiceBindingAsOptional(BuildProducer<KubernetesOptionalResourceDefinitionBuildItem> optionalKinds) {
        optionalKinds.produce((BuildItem)new KubernetesOptionalResourceDefinitionBuildItem(API_VERSION, KIND));
    }

    @BuildStep
    public List<ServiceBindingRequirementBuildItem> createServiceBindingDecorators(ApplicationInfoBuildItem applicationInfo, KubernetesServiceBindingConfig config, List<ServiceBindingQualifierBuildItem> qualifiers) {
        HashMap requirements = new HashMap();
        String applicationName = applicationInfo.getName();
        config.services.forEach((key, s) -> ServiceBindingProcessor.createRequirementFromConfig(applicationName, key, config).ifPresent(r -> requirements.put(key, r)));
        qualifiers.forEach(q -> {
            Optional<ServiceBindingRequirementBuildItem> requirement = ServiceBindingProcessor.createRequirementFromQualifier(applicationName, config, q);
            requirement.ifPresent(r -> {
                String id = q.getId();
                requirements.putIfAbsent(id, r);
            });
        });
        return requirements.values().stream().collect(Collectors.toList());
    }

    @BuildStep
    public List<DecoratorBuildItem> createServiceBindingDecorators(KubernetesServiceBindingConfig serviceBindingConfig, List<ServiceBindingRequirementBuildItem> services, List<KubernetesResourceMetadataBuildItem> resources) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        resources.stream().distinct().forEach(r -> {
            if (!services.isEmpty()) {
                services.forEach(service -> result.add(new DecoratorBuildItem(r.getTarget(), (Object)new AddServiceBindingResourceDecorator(r.getGroup(), r.getVersion(), r.getKind(), r.getName(), serviceBindingConfig, (ServiceBindingRequirementBuildItem)service))));
            }
        });
        return result;
    }

    protected static Optional<ServiceBindingRequirementBuildItem> createRequirementFromConfig(String applicationName, String serviceId, KubernetesServiceBindingConfig config) {
        String name = config.services != null && config.services.containsKey(serviceId) ? config.services.get((Object)serviceId).name.orElse(serviceId) : serviceId;
        return ServiceBindingProcessor.createRequirementFromConfig(applicationName, serviceId, serviceId, name, config);
    }

    protected static Optional<ServiceBindingRequirementBuildItem> createRequirementFromConfig(String applicationName, String defaultsLookupKey, String serviceId, String resourceName, KubernetesServiceBindingConfig config) {
        if (config.services != null && config.services.containsKey(serviceId)) {
            ServiceConfig provided = config.services.get(serviceId);
            String apiVersion = provided.apiVersion.orElseGet(() -> ServiceBindingProcessor.getDefaultQualifiedKind(defaultsLookupKey).map(ServiceBindingProcessor::apiVersion).orElse(""));
            String kind = provided.kind.orElseGet(() -> ServiceBindingProcessor.getDefaultQualifiedKind(defaultsLookupKey).map(ServiceBindingProcessor::kind).orElseThrow(() -> new IllegalStateException("Failed to determing bindable service kind.")));
            return Optional.of(new ServiceBindingRequirementBuildItem(provided.binding.orElse(applicationName + "-" + serviceId), apiVersion, kind, provided.name.orElse(resourceName)));
        }
        return Optional.empty();
    }

    protected static Optional<ServiceBindingRequirementBuildItem> createRequirementFromQualifier(String applicationName, KubernetesServiceBindingConfig config, ServiceBindingQualifierBuildItem qualifier) {
        if (config.services != null && config.services.containsKey(qualifier.getId())) {
            return ServiceBindingProcessor.createRequirementFromConfig(applicationName, qualifier.getKind(), qualifier.getId(), qualifier.getName(), config);
        }
        if (config.services != null && config.services.containsKey(qualifier.getName())) {
            return ServiceBindingProcessor.createRequirementFromConfig(applicationName, qualifier.getKind(), qualifier.getName(), qualifier.getName(), config);
        }
        if (DEFAULTS.containsKey(qualifier.getKind())) {
            String value = DEFAULTS.get(qualifier.getKind());
            return Optional.of(new ServiceBindingRequirementBuildItem(applicationName + "-" + qualifier.getId(), ServiceBindingProcessor.apiVersion(value), ServiceBindingProcessor.kind(value), qualifier.getId()));
        }
        return Optional.empty();
    }

    protected static Optional<String> getDefaultQualifiedKind(String key) {
        if (!DEFAULTS.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(DEFAULTS.get(key));
    }

    protected static String apiVersion(String name) {
        return name.substring(name.indexOf(".") + 1);
    }

    protected static String kind(String name) {
        return name.substring(0, name.indexOf("."));
    }

    static {
        DEFAULTS.put("postgresql", "PostgresCluster.postgres-operator.crunchydata.com/v1beta1");
        DEFAULTS.put("mysql", "PerconaXtraDBCluster.pxc.percona.com/v1-9-0");
        DEFAULTS.put("redis", "Redis.redis.redis.opstreelabs.in/v1beta1");
        DEFAULTS.put("mongodb", "PerconaServerMongoDB.psmdb.percona.com/v1-9-0");
        DEFAULTS.put("kafka", "Kafka.kafka.strimzi.io/v1beta2");
    }
}

