/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.service.binding.runtime;

import io.quarkus.kubernetes.service.binding.runtime.ServiceBinding;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConfigSource;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;

public class JdbcDatasourceUtil {
    private static final Logger log = Logger.getLogger(JdbcDatasourceUtil.class);

    public static Optional<ServiceBindingConfigSource> convert(List<ServiceBinding> serviceBindings, String type) {
        return JdbcDatasourceUtil.convert(serviceBindings, type, type);
    }

    public static Optional<ServiceBindingConfigSource> convert(List<ServiceBinding> serviceBindings, String bindingType, String urlType) {
        Optional<ServiceBinding> matchingByType = ServiceBinding.singleMatchingByType(bindingType, serviceBindings);
        if (!matchingByType.isPresent()) {
            return Optional.empty();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        ServiceBinding binding = matchingByType.get();
        String username = binding.getProperties().get("username");
        if (username != null) {
            properties.put("quarkus.datasource.username", username);
        } else {
            log.debug((Object)"Property 'username' was not found");
        }
        String password = binding.getProperties().get("password");
        if (password != null) {
            properties.put("quarkus.datasource.password", password);
        } else {
            log.debug((Object)"Property 'password' was not found");
        }
        String host = binding.getProperties().get("host");
        String port = binding.getProperties().get("port");
        String database = binding.getProperties().get("database");
        if (host != null && database != null) {
            Object portPart = "";
            if (port != null) {
                portPart = ":" + port;
            }
            properties.put("quarkus.datasource.jdbc.url", String.format("jdbc:%s://%s%s/%s", urlType, host, portPart, database));
        } else {
            log.debug((Object)"One or more of 'host' or 'database' properties were not found");
        }
        return Optional.of(new ServiceBindingConfigSource(bindingType + "-k8s-service-binding-source", properties));
    }
}

