/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.service.binding.runtime;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jboss.logging.Logger;

public final class ServiceBinding {
    private static final Logger log = Logger.getLogger(ServiceBinding.class);
    private static final String PROVIDER = "provider";
    private static final String TYPE = "type";
    private final String name;
    private final String provider;
    private final Map<String, String> properties;
    private final String type;
    private final String bindingDirectory;

    public ServiceBinding(Path bindingDirectory) {
        this(bindingDirectory.getFileName().toString(), ServiceBinding.getFilenameToContentMap(bindingDirectory), bindingDirectory);
    }

    ServiceBinding(String name, Map<String, String> filenameToContentMap, Path bindingDirectory) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String type = null;
        String provider = null;
        for (Map.Entry<String, String> entry : filenameToContentMap.entrySet()) {
            if (TYPE.equals(entry.getKey())) {
                type = entry.getValue();
                continue;
            }
            if (PROVIDER.equals(entry.getKey())) {
                provider = entry.getValue();
                continue;
            }
            properties.put(entry.getKey(), entry.getValue());
        }
        if (type == null) {
            throw new IllegalArgumentException("Directory '" + String.valueOf(bindingDirectory) + "' does not represent a valid Service ServiceBinding directory as it does not specify a type");
        }
        this.bindingDirectory = bindingDirectory.toString();
        this.name = name;
        this.type = type;
        this.provider = provider;
        this.properties = Collections.unmodifiableMap(properties);
    }

    private static Map<String, String> getFilenameToContentMap(Path directory) {
        if (!Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            log.warn((Object)("File '" + String.valueOf(directory) + "' is not a proper service binding directory so it will skipped"));
            return Collections.emptyMap();
        }
        File[] files = directory.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                try {
                    return !Files.isHidden(f.toPath()) && !Files.isDirectory(f.toPath(), new LinkOption[0]);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to determine if file '" + String.valueOf(f) + "' is a regular file", e);
                }
            }
        });
        HashMap<String, String> result = new HashMap<String, String>();
        if (files != null) {
            for (File f : files) {
                try {
                    result.put(f.toPath().getFileName().toString(), Files.readString(f.toPath()).trim());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to read file '" + String.valueOf(f) + "'", e);
                }
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getType() {
        return this.type;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getBindingDirectory() {
        return this.bindingDirectory;
    }

    public String toString() {
        return "ServiceBinding{name='" + this.name + "', provider='" + this.provider + "', type='" + this.type + "'}";
    }

    public static List<ServiceBinding> matchingByType(String type, List<ServiceBinding> all) {
        Objects.requireNonNull(type, "Type must not be null");
        ArrayList<ServiceBinding> result = new ArrayList<ServiceBinding>();
        for (ServiceBinding binding : all) {
            if (!type.equals(binding.getType())) continue;
            result.add(binding);
        }
        return result;
    }

    public static Optional<ServiceBinding> singleMatchingByType(String type, List<ServiceBinding> all) {
        List<ServiceBinding> allMatching = ServiceBinding.matchingByType(type, all);
        if (allMatching.isEmpty()) {
            return Optional.empty();
        }
        ServiceBinding first = allMatching.get(0);
        if (allMatching.size() > 1) {
            log.warn((Object)("More than one ServiceBinding matches type '" + type + "', but only " + String.valueOf(first) + " will be used"));
        }
        return Optional.of(first);
    }
}

