/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.spi;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Collections;
import java.util.Map;

public final class KubernetesRoleBindingBuildItem
extends MultiBuildItem {
    private final String name;
    private final RoleRef roleRef;
    private final String target;
    private final Subject[] subjects;
    private final Map<String, String> labels;

    public KubernetesRoleBindingBuildItem(String role, boolean clusterWide) {
        this(null, role, clusterWide, null);
    }

    public KubernetesRoleBindingBuildItem(String name, String role, boolean clusterWide) {
        this(name, role, clusterWide, null);
    }

    public KubernetesRoleBindingBuildItem(String name, String role, boolean clusterWide, String target) {
        this(name, target, Collections.emptyMap(), new RoleRef(role, clusterWide), new Subject("", "ServiceAccount", name, null));
    }

    public KubernetesRoleBindingBuildItem(String name, String target, Map<String, String> labels, RoleRef roleRef, Subject ... subjects) {
        this.name = name;
        this.target = target;
        this.labels = labels;
        this.roleRef = roleRef;
        this.subjects = subjects;
    }

    public String getName() {
        return this.name;
    }

    public String getTarget() {
        return this.target;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public RoleRef getRoleRef() {
        return this.roleRef;
    }

    public Subject[] getSubjects() {
        return this.subjects;
    }

    public static final class Subject {
        private final String apiGroup;
        private final String kind;
        private final String name;
        private final String namespace;

        public Subject(String apiGroup, String kind, String name, String namespace) {
            this.apiGroup = apiGroup;
            this.kind = kind;
            this.name = name;
            this.namespace = namespace;
        }

        public String getApiGroup() {
            return this.apiGroup;
        }

        public String getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    public static final class RoleRef {
        private final boolean clusterWide;
        private final String name;

        public RoleRef(String name, boolean clusterWide) {
            this.name = name;
            this.clusterWide = clusterWide;
        }

        public boolean isClusterWide() {
            return this.clusterWide;
        }

        public String getName() {
            return this.name;
        }
    }
}

