/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.runtime.config;

import io.smallrye.config.FallbackConfigSourceInterceptor;
import java.util.function.Function;

public class KubernetesConfigFallback
extends FallbackConfigSourceInterceptor {
    private static final String QUARKUS_KUBERNETES_CONFIG_PREFIX = "quarkus.kubernetes.";
    private static final String QUARKUS_OPENSHIFT_CONFIG_PREFIX = "quarkus.openshift.";
    private static final int OPENSHIFT_CONFIG_NAME_BEGIN = "quarkus.openshift.".length();
    private static final String QUARKUS_KNATIVE_CONFIG_PREFIX = "quarkus.knative.";
    private static final int KNATIVE_CONFIG_NAME_BEGIN = "quarkus.knative.".length();

    public KubernetesConfigFallback() {
        super((Function)new Function<String, String>(){

            @Override
            public String apply(String name) {
                if (name.startsWith(KubernetesConfigFallback.QUARKUS_OPENSHIFT_CONFIG_PREFIX)) {
                    return KubernetesConfigFallback.QUARKUS_KUBERNETES_CONFIG_PREFIX + name.substring(OPENSHIFT_CONFIG_NAME_BEGIN);
                }
                if (name.startsWith(KubernetesConfigFallback.QUARKUS_KNATIVE_CONFIG_PREFIX)) {
                    return KubernetesConfigFallback.QUARKUS_KUBERNETES_CONFIG_PREFIX + name.substring(KNATIVE_CONFIG_NAME_BEGIN);
                }
                return name;
            }
        });
    }
}

