/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase;

import io.agroal.api.AgroalDataSource;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.liquibase.LiquibaseDataSource;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseProducer;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

class LiquibaseDatasourceBeanGenerator {
    public static final String LIQUIBASE_BEAN_NAME_PREFIX = "liquibase_";
    private static final String LIQUIBASE_PRODUCER_BEAN_NAME = "LiquibaseDataSourceProducer";
    private static final String LIQUIBASE_PRODUCER_PACKAGE_NAME = LiquibaseProducer.class.getPackage().getName();
    private static final String LIQUIBASE_PRODUCER_TYPE_NAME = LIQUIBASE_PRODUCER_PACKAGE_NAME + "." + "LiquibaseDataSourceProducer";
    private static final int ACCESS_PACKAGE_PROTECTED = 0;
    private final Collection<String> namedDataSourceNames;
    private final BuildProducer<GeneratedBeanBuildItem> generatedBean;

    public LiquibaseDatasourceBeanGenerator(Collection<String> dataSourceNames, BuildProducer<GeneratedBeanBuildItem> generatedBean) {
        this.namedDataSourceNames = dataSourceNames.stream().filter(n -> !DataSourceUtil.isDefault((String)n)).collect(Collectors.toSet());
        this.generatedBean = generatedBean;
    }

    public void createLiquibaseProducerBean() {
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(this.generatedBean);
        ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(LIQUIBASE_PRODUCER_TYPE_NAME).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        FieldCreator defaultProducerField = classCreator.getFieldCreator("defaultProducer", LiquibaseProducer.class);
        defaultProducerField.setModifiers(0);
        defaultProducerField.addAnnotation(Inject.class);
        for (String namedDataSourceName : this.namedDataSourceNames) {
            String dataSourceFieldName = "dataSource" + LiquibaseDatasourceBeanGenerator.hashed(namedDataSourceName);
            FieldCreator dataSourceField = classCreator.getFieldCreator(dataSourceFieldName, DataSource.class);
            dataSourceField.setModifiers(0);
            dataSourceField.addAnnotation(Inject.class);
            dataSourceField.addAnnotation(LiquibaseDatasourceBeanGenerator.annotatedWithNamed(namedDataSourceName));
            String producerMethodName = "createLiquibaseForDataSource" + LiquibaseDatasourceBeanGenerator.hashed(namedDataSourceName);
            MethodCreator liquibaseProducerMethod = classCreator.getMethodCreator(producerMethodName, LiquibaseFactory.class, new Class[0]);
            liquibaseProducerMethod.addAnnotation(Produces.class);
            liquibaseProducerMethod.addAnnotation(Dependent.class);
            liquibaseProducerMethod.addAnnotation(this.annotatedWithLiquibaseDatasource(namedDataSourceName));
            liquibaseProducerMethod.addAnnotation(LiquibaseDatasourceBeanGenerator.annotatedWithNamed(LIQUIBASE_BEAN_NAME_PREFIX + namedDataSourceName));
            liquibaseProducerMethod.returnValue(liquibaseProducerMethod.invokeVirtualMethod(LiquibaseDatasourceBeanGenerator.createLiquibaseMethod(), LiquibaseDatasourceBeanGenerator.resultHandleFor(defaultProducerField, (BytecodeCreator)liquibaseProducerMethod), new ResultHandle[]{LiquibaseDatasourceBeanGenerator.resultHandleFor(dataSourceField, (BytecodeCreator)liquibaseProducerMethod), liquibaseProducerMethod.load(namedDataSourceName)}));
        }
        classCreator.close();
    }

    private static String hashed(String dataSourceName) {
        return "_" + HashUtil.sha1((String)dataSourceName);
    }

    private static MethodDescriptor createLiquibaseMethod() {
        Class[] parameterTypes = new Class[]{AgroalDataSource.class, String.class};
        return MethodDescriptor.ofMethod(LiquibaseProducer.class, (String)"createLiquibase", LiquibaseFactory.class, (Class[])parameterTypes);
    }

    private static ResultHandle resultHandleFor(FieldCreator field, BytecodeCreator method) {
        FieldDescriptor fieldDescriptor = field.getFieldDescriptor();
        return method.readInstanceField(fieldDescriptor, method.getThis());
    }

    private static AnnotationInstance annotatedWithNamed(String dataSourceName) {
        return AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)dataSourceName)});
    }

    private AnnotationInstance annotatedWithLiquibaseDatasource(String dataSourceName) {
        return AnnotationInstance.create((DotName)DotName.createSimple((String)LiquibaseDataSource.class.getName()), null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)dataSourceName)});
    }

    public String toString() {
        return "LiquibaseDatasourceBeanGenerator [dataSourceNames=" + this.namedDataSourceNames + ", generatedBean=" + this.generatedBean + "]";
    }
}

