/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase;

import io.quarkus.agroal.deployment.JdbcDataSourceBuildItem;
import io.quarkus.agroal.deployment.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.liquibase.LiquibaseDatasourceBeanGenerator;
import io.quarkus.liquibase.runtime.LiquibaseBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseProducer;
import io.quarkus.liquibase.runtime.LiquibaseRecorder;
import io.quarkus.liquibase.runtime.LiquibaseRuntimeConfig;
import io.quarkus.liquibase.runtime.graal.LiquibaseServiceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.change.Change;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.configuration.ConfigurationContainer;
import liquibase.database.Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MariaDBDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.LiquibaseDataType;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.license.LicenseService;
import liquibase.lockservice.LockService;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.LiquibaseParser;
import liquibase.parser.NamespaceDetails;
import liquibase.precondition.Precondition;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.LiquibaseService;
import liquibase.servicelocator.ServiceLocator;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.structure.DatabaseObject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.logging.Logger;

class LiquibaseProcessor {
    private static final Logger LOGGER = Logger.getLogger(LiquibaseServiceLoader.class);
    LiquibaseBuildTimeConfig liquibaseBuildConfig;
    private static final Map<String, String> KIND_TO_IMPL;

    LiquibaseProcessor() {
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("io.quarkus.liquibase");
    }

    @BuildStep(onlyIfNot={NativeBuild.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public void fastServiceLoader(LiquibaseRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems) throws IOException {
        DotName liquibaseServiceName = DotName.createSimple((String)LiquibaseService.class.getName());
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/liquibase.idx");){
            IndexReader reader = new IndexReader(in);
            Index index = reader.read();
            HashMap services = new HashMap();
            for (Class c : Arrays.asList(DatabaseObjectComparator.class, NamespaceDetails.class, Precondition.class, Database.class, ChangeLogParser.class, Change.class, SnapshotGenerator.class, ChangeLogHistoryService.class, LiquibaseDataType.class, Executor.class, LockService.class, SqlGenerator.class, LicenseService.class)) {
                ArrayList<String> impls = new ArrayList<String>();
                services.put(c.getName(), impls);
                HashSet classes = new HashSet();
                if (c.isInterface()) {
                    classes.addAll(index.getAllKnownImplementors(DotName.createSimple((String)c.getName())));
                } else {
                    classes.addAll(index.getAllKnownSubclasses(DotName.createSimple((String)c.getName())));
                }
                for (ClassInfo found : classes) {
                    AnnotationInstance annotationInstance;
                    if (Modifier.isAbstract(found.flags()) || Modifier.isInterface(found.flags()) || !found.hasNoArgsConstructor() || !Modifier.isPublic(found.flags()) || (annotationInstance = found.classAnnotation(liquibaseServiceName)) != null && annotationInstance.value("skip").asBoolean()) continue;
                    impls.add(found.name().toString());
                }
            }
            boolean allKnown = true;
            HashSet<String> databases = new HashSet<String>();
            for (JdbcDataSourceBuildItem i : jdbcDataSourceBuildItems) {
                String known = KIND_TO_IMPL.get(i.getDbKind());
                if (known == null) {
                    allKnown = false;
                    continue;
                }
                databases.add(known);
            }
            if (allKnown) {
                services.put(Database.class.getName(), new ArrayList(databases));
            }
            recorder.setJvmServiceImplementations(services);
        }
    }

    @BuildStep(onlyIf={NativeBuild.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void nativeImageConfiguration(LiquibaseRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, BuildProducer<ReflectiveClassBuildItem> reflective, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<GeneratedResourceBuildItem> generatedResource, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitialized, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle) {
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("liquibase.util.StringUtils"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("liquibase.servicelocator.ServiceLocator"));
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("liquibase.diff.compare.CompareControl"));
        reflective.produce((BuildItem)new ReflectiveClassBuildItem(false, true, false, new String[]{"liquibase.change.AbstractSQLChange", "liquibase.database.jvm.JdbcConnection"}));
        reflective.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{"liquibase.change.ColumnConfig", "liquibase.change.AddColumnConfig"}));
        reflective.produce((BuildItem)new ReflectiveClassBuildItem(false, false, true, new String[]{"liquibase.change.ConstraintsConfig"}));
        this.addReflection(reflective, true, Change.class);
        this.addReflection(reflective, false, ConfigurationContainer.class, LiquibaseParser.class, DatabaseObject.class, SqlVisitor.class);
        HashMap<String, List<String>> serviceClassesImplementationRegistry = new HashMap<String, List<String>>();
        Stream.of(DatabaseObjectComparator.class, NamespaceDetails.class, Precondition.class, Database.class, ChangeLogParser.class, Change.class, SnapshotGenerator.class, ChangeLogHistoryService.class, LiquibaseDataType.class, Executor.class, LockService.class, SqlGenerator.class).forEach(t -> this.addService(reflective, (Class<?>)t, true, (Map<String, List<String>>)serviceClassesImplementationRegistry));
        this.addService(reflective, LicenseService.class, false, serviceClassesImplementationRegistry);
        recorder.setServicesImplementations(serviceClassesImplementationRegistry);
        Collection dataSourceNames = jdbcDataSourceBuildItems.stream().map(i -> i.getName()).collect(Collectors.toSet());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(this.getChangeLogs(dataSourceNames).toArray(new String[0])));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.5.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.6.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.7.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.8.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.9.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-ext.xsd", "www.liquibase.org/xml/ns/pro/liquibase-pro-3.8.xsd", "liquibase.build.properties"}));
        resourceBundle.produce((BuildItem)new NativeImageResourceBundleBuildItem("liquibase/i18n/liquibase-core"));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void build(LiquibaseRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<FeatureBuildItem> feature, BuildProducer<BeanContainerListenerBuildItem> beanContainerListener, BuildProducer<GeneratedBeanBuildItem> generatedBean) {
        feature.produce((BuildItem)new FeatureBuildItem("liquibase"));
        AdditionalBeanBuildItem unremovableProducer = AdditionalBeanBuildItem.unremovableOf(LiquibaseProducer.class);
        additionalBean.produce((BuildItem)unremovableProducer);
        Collection dataSourceNames = jdbcDataSourceBuildItems.stream().map(i -> i.getName()).collect(Collectors.toSet());
        new LiquibaseDatasourceBeanGenerator(dataSourceNames, generatedBean).createLiquibaseProducerBean();
        beanContainerListener.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.setLiquibaseBuildConfig(this.liquibaseBuildConfig)));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    ServiceStartBuildItem configureRuntimeProperties(LiquibaseRecorder recorder, LiquibaseRuntimeConfig liquibaseRuntimeConfig, BeanContainerBuildItem beanContainer, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, BuildProducer<JdbcDataSourceSchemaReadyBuildItem> jdbcDataSourceSchemaReady) {
        recorder.configureLiquibaseProperties(liquibaseRuntimeConfig, beanContainer.getValue());
        recorder.doStartActions(liquibaseRuntimeConfig, beanContainer.getValue());
        Collection dataSourceNames = jdbcDataSourceBuildItems.stream().map(i -> i.getName()).collect(Collectors.toSet());
        jdbcDataSourceSchemaReady.produce((BuildItem)new JdbcDataSourceSchemaReadyBuildItem(dataSourceNames));
        return new ServiceStartBuildItem("liquibase");
    }

    private void addService(BuildProducer<ReflectiveClassBuildItem> reflective, Class<?> className, boolean methods, Map<String, List<String>> serviceClassesImplementationRegistry) {
        Class[] classImplementations = ServiceLocator.getInstance().findClasses(className);
        if (classImplementations != null && classImplementations.length > 0) {
            reflective.produce((BuildItem)new ReflectiveClassBuildItem(true, methods, false, classImplementations));
            ArrayList<String> serviceImplementations = new ArrayList<String>();
            for (Class classImpl : classImplementations) {
                serviceImplementations.add(classImpl.getName());
            }
            serviceClassesImplementationRegistry.put(className.getName(), serviceImplementations);
        }
        reflective.produce((BuildItem)new ReflectiveClassBuildItem(false, false, false, new String[]{className.getName()}));
        reflective.produce((BuildItem)new ReflectiveClassBuildItem(false, false, false, new String[]{className.getName()}));
    }

    private void addReflection(BuildProducer<ReflectiveClassBuildItem> reflective, boolean methods, Class<?> ... className) {
        for (Class<?> clazz : className) {
            Class[] impl = ServiceLocator.getInstance().findClasses(clazz);
            if (impl == null || impl.length <= 0) continue;
            reflective.produce((BuildItem)new ReflectiveClassBuildItem(true, methods, false, impl));
        }
    }

    private List<String> getChangeLogs(Collection<String> dataSourceNames) {
        if (dataSourceNames.isEmpty()) {
            return Collections.emptyList();
        }
        ChangeLogParameters changeLogParameters = new ChangeLogParameters();
        ClassLoaderResourceAccessor classLoaderResourceAccessor = new ClassLoaderResourceAccessor(Thread.currentThread().getContextClassLoader());
        ChangeLogParserFactory changeLogParserFactory = ChangeLogParserFactory.getInstance();
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        if (DataSourceUtil.hasDefault(dataSourceNames)) {
            resources.addAll(this.findAllChangeLogs(this.liquibaseBuildConfig.defaultDataSource.changeLog, changeLogParserFactory, classLoaderResourceAccessor, changeLogParameters));
        }
        Collection namedDataSourceChangeLogs = dataSourceNames.stream().filter(n -> !DataSourceUtil.isDefault((String)n)).map(arg_0 -> ((LiquibaseBuildTimeConfig)this.liquibaseBuildConfig).getConfigForDataSourceName(arg_0)).map(c -> c.changeLog).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String namedDataSourceChangeLog : namedDataSourceChangeLogs) {
            resources.addAll(this.findAllChangeLogs(namedDataSourceChangeLog, changeLogParserFactory, classLoaderResourceAccessor, changeLogParameters));
        }
        LOGGER.debugf("Liquibase changeLogs: %s", resources);
        return new ArrayList<String>(resources);
    }

    private Set<String> findAllChangeLogs(String file, ChangeLogParserFactory changeLogParserFactory, ClassLoaderResourceAccessor classLoaderResourceAccessor, ChangeLogParameters changeLogParameters) {
        try {
            ChangeLogParser parser = changeLogParserFactory.getParser(file, (ResourceAccessor)classLoaderResourceAccessor);
            DatabaseChangeLog changelog = parser.parse(file, changeLogParameters, (ResourceAccessor)classLoaderResourceAccessor);
            if (changelog != null) {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                for (ChangeSet changeSet : changelog.getChangeSets()) {
                    result.add(changeSet.getFilePath());
                    for (DatabaseChangeLog parent = changeSet.getChangeLog(); parent != null; parent = parent.getParentChangeLog()) {
                        result.add(parent.getFilePath());
                    }
                }
                result.add(changelog.getFilePath());
                return result;
            }
        }
        catch (LiquibaseException ex) {
            throw new IllegalStateException(ex);
        }
        return Collections.emptySet();
    }

    static {
        HashMap<String, String> knownKindsToImpl = new HashMap<String, String>();
        knownKindsToImpl.put("derby", DerbyDatabase.class.getName());
        knownKindsToImpl.put("h2", H2Database.class.getName());
        knownKindsToImpl.put("mariadb", MariaDBDatabase.class.getName());
        knownKindsToImpl.put("mssql", MSSQLDatabase.class.getName());
        knownKindsToImpl.put("mysql", MySQLDatabase.class.getName());
        knownKindsToImpl.put("postgresql", PostgresDatabase.class.getName());
        KIND_TO_IMPL = Collections.unmodifiableMap(knownKindsToImpl);
    }
}

