/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.liquibase.LiquibaseDataSource;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseContainerProducer;
import io.quarkus.liquibase.runtime.LiquibaseRecorder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import liquibase.change.AbstractSQLChange;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.LiquibaseCommand;
import liquibase.configuration.GlobalConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.datatype.LiquibaseDataType;
import liquibase.diff.DiffGenerator;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.output.changelog.ChangeGenerator;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.lockservice.LockService;
import liquibase.logging.LogFactory;
import liquibase.logging.LogService;
import liquibase.logging.core.DefaultLoggerConfiguration;
import liquibase.logging.core.LogServiceFactory;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserCofiguration;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.NamespaceDetails;
import liquibase.parser.SnapshotParser;
import liquibase.precondition.Precondition;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.SnapshotSerializer;
import liquibase.servicelocator.ServiceLocator;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.sql.visitor.AppendSqlVisitor;
import liquibase.sql.visitor.PrependSqlVisitor;
import liquibase.sql.visitor.RegExpReplaceSqlVisitor;
import liquibase.sql.visitor.ReplaceSqlVisitor;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.structure.DatabaseObject;
import org.jboss.logging.Logger;

class LiquibaseProcessor {
    private static final Logger LOGGER = Logger.getLogger(LiquibaseProcessor.class);
    private static final String LIQUIBASE_BEAN_NAME_PREFIX = "liquibase_";

    LiquibaseProcessor() {
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.LIQUIBASE);
    }

    @BuildStep(onlyIf={NativeBuild.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void nativeImageConfiguration(LiquibaseRecorder recorder, LiquibaseBuildTimeConfig liquibaseBuildConfig, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, BuildProducer<ReflectiveClassBuildItem> reflective, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ServiceProviderBuildItem> services, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitialized, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle) {
        runtimeInitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem(CompareControl.class.getName()));
        reflective.produce((BuildItem)new ReflectiveClassBuildItem(false, true, false, new String[]{AbstractSQLChange.class.getName(), JdbcConnection.class.getName()}));
        reflective.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{ChangeLogParserCofiguration.class.getName(), DefaultLoggerConfiguration.class.getName(), GlobalConfiguration.class.getName(), LiquibaseProConfiguration.class.getName(), LicenseServiceFactory.class.getName(), ExecutorService.class.getName(), ChangeFactory.class.getName(), LogServiceFactory.class.getName(), LogFactory.class.getName(), ColumnConfig.class.getName(), AddColumnConfig.class.getName(), PrependSqlVisitor.class.getName(), ReplaceSqlVisitor.class.getName(), AppendSqlVisitor.class.getName(), RegExpReplaceSqlVisitor.class.getName()}));
        reflective.produce((BuildItem)new ReflectiveClassBuildItem(false, false, true, new String[]{ConstraintsConfig.class.getName()}));
        Collection dataSourceNames = jdbcDataSourceBuildItems.stream().map(i -> i.getName()).collect(Collectors.toSet());
        resource.produce((BuildItem)new NativeImageResourceBuildItem(this.getChangeLogs(dataSourceNames, liquibaseBuildConfig).toArray(new String[0])));
        Stream.of(Change.class, ChangeLogHistoryService.class, LiquibaseCommand.class, Database.class, DatabaseConnection.class, LiquibaseDataType.class, DatabaseObjectComparator.class, DiffGenerator.class, ChangeGenerator.class, Executor.class, LicenseService.class, LockService.class, LogService.class, ChangeLogParser.class, NamespaceDetails.class, SnapshotParser.class, Precondition.class, ChangeLogSerializer.class, SnapshotSerializer.class, ServiceLocator.class, SnapshotGenerator.class, SqlGenerator.class, DatabaseObject.class).forEach(t -> this.addService(services, reflective, (Class<?>)t));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.5.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.6.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.7.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.8.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.9.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-3.10.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-4.0.xsd", "www.liquibase.org/xml/ns/dbchangelog/dbchangelog-ext.xsd", "www.liquibase.org/xml/ns/pro/liquibase-pro-3.8.xsd", "www.liquibase.org/xml/ns/pro/liquibase-pro-3.9.xsd", "www.liquibase.org/xml/ns/pro/liquibase-pro-3.10.xsd", "www.liquibase.org/xml/ns/pro/liquibase-pro-4.0.xsd", "liquibase.build.properties"}));
        resourceBundle.produce((BuildItem)new NativeImageResourceBundleBuildItem("liquibase/i18n/liquibase-core"));
    }

    private void addService(BuildProducer<ServiceProviderBuildItem> services, BuildProducer<ReflectiveClassBuildItem> reflective, Class<?> serviceClass) {
        try {
            String service = "META-INF/services/" + serviceClass.getName();
            Set implementations = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)service);
            services.produce((BuildItem)new ServiceProviderBuildItem(serviceClass.getName(), implementations.toArray(new String[0])));
            reflective.produce((BuildItem)new ReflectiveClassBuildItem(true, true, false, implementations.toArray(new String[0])));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.LIQUIBASE);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem createBeansAndStartActions(LiquibaseRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItem) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{LiquibaseContainerProducer.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(LiquibaseDataSource.class).build());
        Set<String> dataSourceNames = this.getDataSourceNames(jdbcDataSourceBuildItems);
        for (String dataSourceName : dataSourceNames) {
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(LiquibaseFactory.class).scope(Dependent.class)).setRuntimeInit().unremovable()).supplier(recorder.liquibaseSupplier(dataSourceName));
            if (DataSourceUtil.isDefault((String)dataSourceName)) {
                configurator.addQualifier(Default.class);
            } else {
                String beanName = LIQUIBASE_BEAN_NAME_PREFIX + dataSourceName;
                configurator.name(beanName);
                configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)beanName).done();
                configurator.addQualifier().annotation(LiquibaseDataSource.class).addValue("value", (Object)dataSourceName).done();
            }
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
        }
        recorder.doStartActions();
        schemaReadyBuildItem.produce((BuildItem)new JdbcDataSourceSchemaReadyBuildItem(dataSourceNames));
        return new ServiceStartBuildItem("liquibase");
    }

    private Set<String> getDataSourceNames(List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems) {
        HashSet<String> result = new HashSet<String>(jdbcDataSourceBuildItems.size());
        for (JdbcDataSourceBuildItem item : jdbcDataSourceBuildItems) {
            result.add(item.getName());
        }
        return result;
    }

    private List<String> getChangeLogs(Collection<String> dataSourceNames, LiquibaseBuildTimeConfig liquibaseBuildConfig) {
        if (dataSourceNames.isEmpty()) {
            return Collections.emptyList();
        }
        ChangeLogParameters changeLogParameters = new ChangeLogParameters();
        ClassLoaderResourceAccessor classLoaderResourceAccessor = new ClassLoaderResourceAccessor(Thread.currentThread().getContextClassLoader());
        ChangeLogParserFactory changeLogParserFactory = ChangeLogParserFactory.getInstance();
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        if (DataSourceUtil.hasDefault(dataSourceNames)) {
            resources.addAll(this.findAllChangeLogs(liquibaseBuildConfig.defaultDataSource.changeLog, changeLogParserFactory, classLoaderResourceAccessor, changeLogParameters));
        }
        Collection namedDataSourceChangeLogs = dataSourceNames.stream().filter(n -> !DataSourceUtil.isDefault((String)n)).map(arg_0 -> ((LiquibaseBuildTimeConfig)liquibaseBuildConfig).getConfigForDataSourceName(arg_0)).map(c -> c.changeLog).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String namedDataSourceChangeLog : namedDataSourceChangeLogs) {
            resources.addAll(this.findAllChangeLogs(namedDataSourceChangeLog, changeLogParserFactory, classLoaderResourceAccessor, changeLogParameters));
        }
        LOGGER.debugf("Liquibase changeLogs: %s", resources);
        return new ArrayList<String>(resources);
    }

    private Set<String> findAllChangeLogs(String file, ChangeLogParserFactory changeLogParserFactory, ClassLoaderResourceAccessor classLoaderResourceAccessor, ChangeLogParameters changeLogParameters) {
        try {
            ChangeLogParser parser = changeLogParserFactory.getParser(file, (ResourceAccessor)classLoaderResourceAccessor);
            DatabaseChangeLog changelog = parser.parse(file, changeLogParameters, (ResourceAccessor)classLoaderResourceAccessor);
            if (changelog != null) {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                for (ChangeSet changeSet : changelog.getChangeSets()) {
                    result.add(changeSet.getFilePath());
                    for (DatabaseChangeLog parent = changeSet.getChangeLog(); parent != null; parent = parent.getParentChangeLog()) {
                        result.add(parent.getFilePath());
                    }
                }
                result.add(changelog.getFilePath());
                return result;
            }
        }
        catch (LiquibaseException ex) {
            throw new IllegalStateException(ex);
        }
        return Collections.emptySet();
    }
}

