/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.mongodb;

import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbBuildTimeConfig;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbConfig;
import io.quarkus.mongodb.runtime.MongoClientConfig;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class LiquibaseMongodbFactory {
    private final MongoClientConfig mongoClientConfig;
    private final LiquibaseMongodbConfig liquibaseMongodbConfig;
    private final LiquibaseMongodbBuildTimeConfig liquibaseMongodbBuildTimeConfig;
    Pattern HAS_DB = Pattern.compile("(mongodb|mongodb\\+srv)://[^/]*/.*");

    public LiquibaseMongodbFactory(LiquibaseMongodbConfig config, LiquibaseMongodbBuildTimeConfig liquibaseMongodbBuildTimeConfig, MongoClientConfig mongoClientConfig) {
        this.liquibaseMongodbConfig = config;
        this.liquibaseMongodbBuildTimeConfig = liquibaseMongodbBuildTimeConfig;
        this.mongoClientConfig = mongoClientConfig;
    }

    public Liquibase createLiquibase() {
        try {
            Database database;
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(Thread.currentThread().getContextClassLoader());
            Object connectionString = this.mongoClientConfig.connectionString.orElse("mongodb://localhost:27017");
            if (!this.HAS_DB.matcher((CharSequence)connectionString).matches()) {
                connectionString = (String)connectionString + "/" + (String)this.mongoClientConfig.database.orElseThrow(() -> new IllegalArgumentException("Config property 'quarkus.mongodb.database' must be defined when no database exist in the connection string"));
            }
            if ((database = DatabaseFactory.getInstance().openDatabase((String)connectionString, (String)this.mongoClientConfig.credentials.username.orElse(null), (String)this.mongoClientConfig.credentials.password.orElse(null), null, (ResourceAccessor)resourceAccessor)) != null) {
                this.liquibaseMongodbConfig.liquibaseCatalogName.ifPresent(arg_0 -> ((Database)database).setLiquibaseCatalogName(arg_0));
                this.liquibaseMongodbConfig.liquibaseSchemaName.ifPresent(arg_0 -> ((Database)database).setLiquibaseSchemaName(arg_0));
                this.liquibaseMongodbConfig.liquibaseTablespaceName.ifPresent(arg_0 -> ((Database)database).setLiquibaseTablespaceName(arg_0));
                if (this.liquibaseMongodbConfig.defaultCatalogName.isPresent()) {
                    database.setDefaultCatalogName(this.liquibaseMongodbConfig.defaultCatalogName.get());
                }
                if (this.liquibaseMongodbConfig.defaultSchemaName.isPresent()) {
                    database.setDefaultSchemaName(this.liquibaseMongodbConfig.defaultSchemaName.get());
                }
            }
            Liquibase liquibase = new Liquibase(this.liquibaseMongodbBuildTimeConfig.changeLog, (ResourceAccessor)resourceAccessor, database);
            for (Map.Entry<String, String> entry : this.liquibaseMongodbConfig.changeLogParameters.entrySet()) {
                liquibase.getChangeLogParameters().set(entry.getKey(), (Object)entry.getValue());
            }
            return liquibase;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public LiquibaseMongodbConfig getConfiguration() {
        return this.liquibaseMongodbConfig;
    }

    public LabelExpression createLabels() {
        return new LabelExpression((Collection)this.liquibaseMongodbConfig.labels.orElse(null));
    }

    public Contexts createContexts() {
        return new Contexts((Collection)this.liquibaseMongodbConfig.contexts.orElse(null));
    }
}

