/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.mongodb.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import liquibase.Scope;
import liquibase.util.LiquibaseUtil;

@TargetClass(value=LiquibaseUtil.class)
final class SubstituteLiquibaseUtil {
    @Alias
    private static Properties liquibaseBuildProperties;

    SubstituteLiquibaseUtil() {
    }

    @Substitute
    private static String getBuildInfo(String propertyId) {
        String value;
        if (liquibaseBuildProperties == null) {
            try {
                liquibaseBuildProperties = new Properties();
                Enumeration<URL> propertiesUrls = Scope.getCurrentScope().getClassLoader().getResources("liquibase.build.properties");
                while (propertiesUrls.hasMoreElements()) {
                    URL url = propertiesUrls.nextElement();
                    InputStream buildProperties = url.openStream();
                    try {
                        if (buildProperties == null) continue;
                        liquibaseBuildProperties.load(buildProperties);
                    }
                    finally {
                        if (buildProperties == null) continue;
                        buildProperties.close();
                    }
                }
            }
            catch (IOException e) {
                Scope.getCurrentScope().getLog(LiquibaseUtil.class).severe("Cannot read liquibase.build.properties", (Throwable)e);
            }
        }
        if ((value = liquibaseBuildProperties.getProperty(propertyId)) == null) {
            value = "UNKNOWN";
        }
        return value;
    }
}

