/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.mongodb;

import com.mongodb.client.MongoClient;
import io.quarkus.arc.Arc;
import io.quarkus.liquibase.common.runtime.NativeImageResourceAccessor;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbBuildTimeConfig;
import io.quarkus.liquibase.mongodb.runtime.LiquibaseMongodbConfig;
import io.quarkus.mongodb.runtime.MongoClientConfig;
import io.quarkus.mongodb.runtime.MongoClients;
import io.quarkus.mongodb.runtime.MongodbConfig;
import io.quarkus.runtime.ImageMode;
import io.quarkus.runtime.util.StringUtil;
import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.ext.mongodb.database.MongoConnection;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class LiquibaseMongodbFactory {
    private static final Pattern HAS_DB = Pattern.compile("(?<prefix>mongodb://|mongodb\\+srv://)(?<hosts>[^/]*)(?<slash>[/]?)(?<db>[^?]*)(?<options>\\??.*)");
    private final LiquibaseMongodbConfig liquibaseMongodbConfig;
    private final LiquibaseMongodbBuildTimeConfig liquibaseMongodbBuildTimeConfig;
    private final MongodbConfig mongodbConfig;

    public LiquibaseMongodbFactory(LiquibaseMongodbConfig config, LiquibaseMongodbBuildTimeConfig liquibaseMongodbBuildTimeConfig, MongodbConfig mongodbConfig) {
        this.liquibaseMongodbConfig = config;
        this.liquibaseMongodbBuildTimeConfig = liquibaseMongodbBuildTimeConfig;
        this.mongodbConfig = mongodbConfig;
    }

    private ResourceAccessor resolveResourceAccessor() throws FileNotFoundException {
        CompositeResourceAccessor rootAccessor = new CompositeResourceAccessor(new ResourceAccessor[0]);
        return ImageMode.current().isNativeImage() ? this.nativeImageResourceAccessor(rootAccessor) : this.defaultResourceAccessor(rootAccessor);
    }

    private ResourceAccessor defaultResourceAccessor(CompositeResourceAccessor rootAccessor) throws FileNotFoundException {
        rootAccessor.addResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor(Thread.currentThread().getContextClassLoader()));
        if (!this.liquibaseMongodbBuildTimeConfig.changeLog().startsWith("filesystem:") && this.liquibaseMongodbBuildTimeConfig.searchPath().isEmpty()) {
            return rootAccessor;
        }
        if (this.liquibaseMongodbBuildTimeConfig.searchPath().isEmpty()) {
            return rootAccessor.addResourceAccessor((ResourceAccessor)new DirectoryResourceAccessor(Paths.get(StringUtil.changePrefix((String)this.liquibaseMongodbBuildTimeConfig.changeLog(), (String)"filesystem:", (String)""), new String[0]).getParent()));
        }
        for (String searchPath : this.liquibaseMongodbBuildTimeConfig.searchPath().get()) {
            rootAccessor.addResourceAccessor((ResourceAccessor)new DirectoryResourceAccessor(Paths.get(searchPath, new String[0])));
        }
        return rootAccessor;
    }

    private ResourceAccessor nativeImageResourceAccessor(CompositeResourceAccessor rootAccessor) {
        return rootAccessor.addResourceAccessor((ResourceAccessor)new NativeImageResourceAccessor());
    }

    private String parseChangeLog(String changeLog) {
        if (changeLog.startsWith("filesystem:") && this.liquibaseMongodbBuildTimeConfig.searchPath().isEmpty()) {
            return Paths.get(StringUtil.changePrefix((String)changeLog, (String)"filesystem:", (String)""), new String[0]).getFileName().toString();
        }
        if (changeLog.startsWith("filesystem:")) {
            return StringUtil.changePrefix((String)changeLog, (String)"filesystem:", (String)"");
        }
        if (changeLog.startsWith("classpath:")) {
            return StringUtil.changePrefix((String)changeLog, (String)"classpath:", (String)"");
        }
        return changeLog;
    }

    public Liquibase createLiquibase() {
        Liquibase liquibase;
        block20: {
            ResourceAccessor resourceAccessor = this.resolveResourceAccessor();
            try {
                MongoClientConfig mongoClientConfig;
                String mongoClientName;
                MongoClients mongoClients = (MongoClients)Arc.container().instance(MongoClients.class, new Annotation[0]).get();
                if (this.liquibaseMongodbConfig.mongoClientName().isPresent()) {
                    mongoClientName = this.liquibaseMongodbConfig.mongoClientName().get();
                    mongoClientConfig = (MongoClientConfig)this.mongodbConfig.mongoClientConfigs().get(mongoClientName);
                    if (mongoClientConfig == null) {
                        throw new IllegalArgumentException("Mongo client named '%s' not found".formatted(mongoClientName));
                    }
                } else {
                    mongoClientConfig = this.mongodbConfig.defaultMongoClientConfig();
                    mongoClientName = "<default>";
                }
                String parsedChangeLog = this.parseChangeLog(this.liquibaseMongodbBuildTimeConfig.changeLog());
                String connectionString = mongoClientConfig.connectionString().orElse("mongodb://localhost:27017");
                Matcher matcher = HAS_DB.matcher(connectionString);
                Optional<String> maybeDatabase = mongoClientConfig.database();
                if (maybeDatabase.isEmpty()) {
                    if (matcher.matches() && !StringUtil.isNullOrEmpty((String)matcher.group("db"))) {
                        maybeDatabase = Optional.of(matcher.group("db"));
                    } else {
                        throw new IllegalArgumentException("Config property 'quarkus.mongodb.database' must be defined when no database exist in the connection string");
                    }
                }
                Database database = this.createDatabase(mongoClients, mongoClientName, (String)maybeDatabase.get());
                if (this.liquibaseMongodbConfig.liquibaseCatalogName().isPresent()) {
                    database.setLiquibaseCatalogName(this.liquibaseMongodbConfig.liquibaseCatalogName().get());
                }
                if (this.liquibaseMongodbConfig.liquibaseSchemaName().isPresent()) {
                    database.setLiquibaseSchemaName(this.liquibaseMongodbConfig.liquibaseSchemaName().get());
                }
                if (this.liquibaseMongodbConfig.liquibaseTablespaceName().isPresent()) {
                    database.setLiquibaseTablespaceName(this.liquibaseMongodbConfig.liquibaseTablespaceName().get());
                }
                if (this.liquibaseMongodbConfig.defaultCatalogName().isPresent()) {
                    database.setDefaultCatalogName(this.liquibaseMongodbConfig.defaultCatalogName().get());
                }
                if (this.liquibaseMongodbConfig.defaultSchemaName().isPresent()) {
                    database.setDefaultSchemaName(this.liquibaseMongodbConfig.defaultSchemaName().get());
                }
                Liquibase liquibase2 = new Liquibase(parsedChangeLog, resourceAccessor, database);
                for (Map.Entry<String, String> entry : this.liquibaseMongodbConfig.changeLogParameters().entrySet()) {
                    liquibase2.getChangeLogParameters().set(entry.getKey(), (Object)entry.getValue());
                }
                liquibase = liquibase2;
                if (resourceAccessor == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAccessor != null) {
                        try {
                            resourceAccessor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            resourceAccessor.close();
        }
        return liquibase;
    }

    private Database createDatabase(MongoClients clients, String clientName, String databaseName) {
        MongoConnection databaseConnection = new MongoConnection();
        MongoClient mongoClient = clients.createMongoClient(clientName);
        databaseConnection.setMongoClient(mongoClient);
        databaseConnection.setMongoDatabase(mongoClient.getDatabase(databaseName));
        MongoLiquibaseDatabase database = new MongoLiquibaseDatabase();
        database.setConnection((DatabaseConnection)databaseConnection);
        return database;
    }

    public LiquibaseMongodbConfig getConfiguration() {
        return this.liquibaseMongodbConfig;
    }

    public LabelExpression createLabels() {
        return new LabelExpression((Collection)this.liquibaseMongodbConfig.labels().orElse(null));
    }

    public Contexts createContexts() {
        return new Contexts((Collection)this.liquibaseMongodbConfig.contexts().orElse(null));
    }
}

