/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase;

import io.agroal.api.AgroalDataSource;
import io.quarkus.liquibase.runtime.LiquibaseConfig;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class LiquibaseFactory {
    private DataSource dataSource;
    private LiquibaseConfig config;

    public LiquibaseFactory(LiquibaseConfig config, AgroalDataSource datasource) {
        this.dataSource = datasource;
        this.config = config;
    }

    public Liquibase createLiquibase() {
        try {
            ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor(Thread.currentThread().getContextClassLoader());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.dataSource.getConnection()));
            if (database != null) {
                database.setDatabaseChangeLogLockTableName(this.config.databaseChangeLogLockTableName);
                database.setDatabaseChangeLogTableName(this.config.databaseChangeLogTableName);
                this.config.liquibaseCatalogName.ifPresent(arg_0 -> ((Database)database).setLiquibaseCatalogName(arg_0));
                this.config.liquibaseSchemaName.ifPresent(arg_0 -> ((Database)database).setLiquibaseSchemaName(arg_0));
                this.config.liquibaseTablespaceName.ifPresent(arg_0 -> ((Database)database).setLiquibaseTablespaceName(arg_0));
                if (this.config.defaultCatalogName.isPresent()) {
                    database.setDefaultCatalogName(this.config.defaultCatalogName.get());
                }
                if (this.config.defaultSchemaName.isPresent()) {
                    database.setDefaultSchemaName(this.config.defaultSchemaName.get());
                }
            }
            return new Liquibase(this.config.changeLog, (ResourceAccessor)resourceAccessor, database);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public LiquibaseConfig getConfiguration() {
        return this.config;
    }

    public LabelExpression createLabels() {
        return new LabelExpression(this.config.labels);
    }

    public Contexts createContexts() {
        return new Contexts(this.config.contexts);
    }
}

