/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseConfig;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceRuntimeConfig;

class LiquibaseCreator {
    private final LiquibaseDataSourceRuntimeConfig liquibaseRuntimeConfig;
    private final LiquibaseDataSourceBuildTimeConfig liquibaseBuildTimeConfig;

    public LiquibaseCreator(LiquibaseDataSourceRuntimeConfig liquibaseRuntimeConfig, LiquibaseDataSourceBuildTimeConfig liquibaseBuildTimeConfig) {
        this.liquibaseRuntimeConfig = liquibaseRuntimeConfig;
        this.liquibaseBuildTimeConfig = liquibaseBuildTimeConfig;
    }

    public LiquibaseFactory createLiquibase(AgroalDataSource dataSource) {
        LiquibaseConfig config = new LiquibaseConfig();
        config.changeLog = this.liquibaseBuildTimeConfig.changeLog;
        this.liquibaseRuntimeConfig.labels.ifPresent(c -> {
            config.labels = c;
        });
        this.liquibaseRuntimeConfig.contexts.ifPresent(c -> {
            config.contexts = c;
        });
        this.liquibaseRuntimeConfig.databaseChangeLogLockTableName.ifPresent(c -> {
            config.databaseChangeLogLockTableName = c;
        });
        this.liquibaseRuntimeConfig.databaseChangeLogTableName.ifPresent(c -> {
            config.databaseChangeLogTableName = c;
        });
        config.defaultSchemaName = this.liquibaseRuntimeConfig.defaultSchemaName;
        config.defaultCatalogName = this.liquibaseRuntimeConfig.defaultCatalogName;
        config.liquibaseTablespaceName = this.liquibaseRuntimeConfig.liquibaseTablespaceName;
        config.liquibaseSchemaName = this.liquibaseRuntimeConfig.liquibaseSchemaName;
        config.liquibaseCatalogName = this.liquibaseRuntimeConfig.liquibaseCatalogName;
        config.migrateAtStart = this.liquibaseRuntimeConfig.migrateAtStart;
        config.cleanAtStart = this.liquibaseRuntimeConfig.cleanAtStart;
        config.validateOnMigrate = this.liquibaseRuntimeConfig.validateOnMigrate;
        return new LiquibaseFactory(config, dataSource);
    }
}

