/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseCreator;
import io.quarkus.liquibase.runtime.LiquibaseRuntimeConfig;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;

@ApplicationScoped
public class LiquibaseProducer {
    private static final String ERROR_NOT_READY = "The Liquibase settings are not ready to be consumed: the %s configuration has not been injected yet";
    @Inject
    @Default
    Instance<AgroalDataSource> defaultDataSource;
    private LiquibaseRuntimeConfig liquibaseRuntimeConfig;
    private LiquibaseBuildTimeConfig liquibaseBuildConfig;

    @Produces
    @Dependent
    @Default
    public LiquibaseFactory produceLiquibase() {
        return this.createDefaultLiquibase((AgroalDataSource)this.defaultDataSource.get());
    }

    public void setLiquibaseRuntimeConfig(LiquibaseRuntimeConfig liquibaseRuntimeConfig) {
        this.liquibaseRuntimeConfig = liquibaseRuntimeConfig;
    }

    public void setLiquibaseBuildConfig(LiquibaseBuildTimeConfig liquibaseBuildConfig) {
        this.liquibaseBuildConfig = liquibaseBuildConfig;
    }

    private LiquibaseFactory createDefaultLiquibase(AgroalDataSource dataSource) {
        return new LiquibaseCreator(this.getLiquibaseRuntimeConfig().defaultDataSource, this.getLiquibaseBuildConfig().defaultDataSource).createLiquibase(dataSource);
    }

    public LiquibaseFactory createLiquibase(AgroalDataSource dataSource, String dataSourceName) {
        return new LiquibaseCreator(this.getLiquibaseRuntimeConfig().getConfigForDataSourceName(dataSourceName), this.getLiquibaseBuildConfig().getConfigForDataSourceName(dataSourceName)).createLiquibase(dataSource);
    }

    private LiquibaseRuntimeConfig getLiquibaseRuntimeConfig() {
        return LiquibaseProducer.failIfNotReady(this.liquibaseRuntimeConfig, "runtime");
    }

    private LiquibaseBuildTimeConfig getLiquibaseBuildConfig() {
        return LiquibaseProducer.failIfNotReady(this.liquibaseBuildConfig, "build");
    }

    private static <T> T failIfNotReady(T config, String name) {
        if (config == null) {
            throw new IllegalStateException(String.format(ERROR_NOT_READY, name));
        }
        return config;
    }
}

