/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.liquibase.LiquibaseDataSource;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceRuntimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseProducer;
import io.quarkus.liquibase.runtime.LiquibaseRuntimeConfig;
import io.quarkus.liquibase.runtime.graal.LiquibaseServiceLoader;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Default;
import javax.enterprise.util.AnnotationLiteral;
import liquibase.Liquibase;
import liquibase.exception.ServiceNotFoundException;
import liquibase.servicelocator.ServiceLocator;
import org.jboss.logging.Logger;

@Recorder
public class LiquibaseRecorder {
    private static final Logger log = Logger.getLogger(LiquibaseRecorder.class);

    public void setServicesImplementations(Map<String, List<String>> serviceLoader) {
        LiquibaseServiceLoader.setServicesImplementations(serviceLoader);
    }

    public BeanContainerListener setLiquibaseBuildConfig(LiquibaseBuildTimeConfig liquibaseBuildConfig) {
        return beanContainer -> {
            LiquibaseProducer producer = (LiquibaseProducer)beanContainer.instance(LiquibaseProducer.class, new Annotation[0]);
            producer.setLiquibaseBuildConfig(liquibaseBuildConfig);
        };
    }

    public void configureLiquibaseProperties(LiquibaseRuntimeConfig liquibaseRuntimeConfig, BeanContainer container) {
        ((LiquibaseProducer)container.instance(LiquibaseProducer.class, new Annotation[0])).setLiquibaseRuntimeConfig(liquibaseRuntimeConfig);
    }

    public void doStartActions(LiquibaseRuntimeConfig config, BeanContainer container) {
        try {
            if (config.defaultDataSource.cleanAtStart) {
                this.dropAll(container, (AnnotationLiteral<? extends Annotation>)Default.Literal.INSTANCE);
            }
            if (config.defaultDataSource.migrateAtStart) {
                if (config.defaultDataSource.validateOnMigrate) {
                    this.validate(container, (AnnotationLiteral<? extends Annotation>)Default.Literal.INSTANCE);
                }
                this.migrate(container, (AnnotationLiteral<? extends Annotation>)Default.Literal.INSTANCE);
            }
            for (Map.Entry<String, LiquibaseDataSourceRuntimeConfig> configPerDataSource : config.namedDataSources.entrySet()) {
                if (configPerDataSource.getValue().cleanAtStart) {
                    this.dropAll(container, LiquibaseDataSource.LiquibaseDataSourceLiteral.of(configPerDataSource.getKey()));
                }
                if (!configPerDataSource.getValue().migrateAtStart) continue;
                if (configPerDataSource.getValue().validateOnMigrate) {
                    this.validate(container, LiquibaseDataSource.LiquibaseDataSourceLiteral.of(configPerDataSource.getKey()));
                }
                this.migrate(container, LiquibaseDataSource.LiquibaseDataSourceLiteral.of(configPerDataSource.getKey()));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void dropAll(BeanContainer container, AnnotationLiteral<? extends Annotation> qualifier) throws Exception {
        LiquibaseFactory liquibaseFactory = (LiquibaseFactory)container.instance(LiquibaseFactory.class, new Annotation[]{qualifier});
        try (Liquibase liquibase = liquibaseFactory.createLiquibase();){
            liquibase.dropAll();
        }
    }

    private void migrate(BeanContainer container, AnnotationLiteral<? extends Annotation> qualifier) throws Exception {
        LiquibaseFactory liquibaseFactory = (LiquibaseFactory)container.instance(LiquibaseFactory.class, new Annotation[]{qualifier});
        try (Liquibase liquibase = liquibaseFactory.createLiquibase();){
            liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
        }
    }

    private void validate(BeanContainer container, AnnotationLiteral<? extends Annotation> qualifier) throws Exception {
        LiquibaseFactory liquibaseFactory = (LiquibaseFactory)container.instance(LiquibaseFactory.class, new Annotation[]{qualifier});
        try (Liquibase liquibase = liquibaseFactory.createLiquibase();){
            liquibase.validate();
        }
    }

    public void setJvmServiceImplementations(final Map<String, List<String>> services) {
        ServiceLocator.setInstance((ServiceLocator)new ServiceLocator(){

            public <T> Class<? extends T>[] findClasses(Class<T> requiredInterface) throws ServiceNotFoundException {
                List found = (List)services.get(requiredInterface.getName());
                if (found == null) {
                    log.warnf("Failed to find pre-indexed service %s, falling back to slow classpath scanning", requiredInterface);
                    return super.findClasses(requiredInterface);
                }
                ArrayList ret = new ArrayList();
                for (String i : found) {
                    try {
                        ret.add(Class.forName(i, false, Thread.currentThread().getContextClassLoader()));
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)"Failed to load Liquibase service", (Throwable)e);
                    }
                }
                return ret.toArray(new Class[0]);
            }
        });
    }
}

