/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime.graal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LiquibaseServiceLoader {
    private static Map<String, List<String>> servicesImplementations;

    public static List<Class<?>> findClassesImpl(Class<?> requiredInterface) {
        List<String> classesImplementationNames = servicesImplementations.get(requiredInterface.getName());
        if (classesImplementationNames == null || classesImplementationNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList classImplementations = new ArrayList();
        for (String classImplementation : classesImplementationNames) {
            try {
                classImplementations.add(Class.forName(classImplementation));
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException(exception);
            }
        }
        return classImplementations;
    }

    public static void setServicesImplementations(Map<String, List<String>> servicesImplementations) {
        LiquibaseServiceLoader.servicesImplementations = servicesImplementations;
    }
}

