/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseContainer;
import io.quarkus.liquibase.runtime.LiquibaseCreator;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceRuntimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseRuntimeConfig;
import javax.sql.DataSource;

public class LiquibaseContainerProducer {
    private final LiquibaseBuildTimeConfig liquibaseBuildTimeConfig;
    private final LiquibaseRuntimeConfig liquibaseRuntimeConfig;

    public LiquibaseContainerProducer(LiquibaseBuildTimeConfig liquibaseBuildTimeConfig, LiquibaseRuntimeConfig liquibaseRuntimeConfig) {
        this.liquibaseBuildTimeConfig = liquibaseBuildTimeConfig;
        this.liquibaseRuntimeConfig = liquibaseRuntimeConfig;
    }

    public LiquibaseContainer createLiquibaseFactory(DataSource dataSource, String dataSourceName) {
        LiquibaseDataSourceBuildTimeConfig matchingBuildTimeConfig = DataSourceUtil.isDefault((String)dataSourceName) ? this.liquibaseBuildTimeConfig.defaultDataSource : this.liquibaseBuildTimeConfig.getConfigForDataSourceName(dataSourceName);
        LiquibaseDataSourceRuntimeConfig matchingRuntimeConfig = DataSourceUtil.isDefault((String)dataSourceName) ? this.liquibaseRuntimeConfig.defaultDataSource : this.liquibaseRuntimeConfig.getConfigForDataSourceName(dataSourceName);
        LiquibaseFactory liquibaseFactory = new LiquibaseCreator(matchingRuntimeConfig, matchingBuildTimeConfig).createLiquibase(dataSource);
        return new LiquibaseContainer(liquibaseFactory, matchingRuntimeConfig.cleanAtStart, matchingRuntimeConfig.migrateAtStart, matchingRuntimeConfig.validateOnMigrate);
    }
}

