/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.agroal.runtime.UnconfiguredDataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseConfig;
import io.quarkus.liquibase.runtime.LiquibaseFactoryProducer;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.sql.DataSource;
import liquibase.Liquibase;

@Recorder
public class LiquibaseRecorder {
    public Supplier<LiquibaseFactory> liquibaseSupplier(String dataSourceName) {
        AgroalDataSource dataSource = DataSources.fromName((String)dataSourceName);
        if (dataSource instanceof UnconfiguredDataSource) {
            return new Supplier<LiquibaseFactory>(){

                @Override
                public LiquibaseFactory get() {
                    throw new UnsatisfiedResolutionException("No datasource has been configured");
                }
            };
        }
        LiquibaseFactoryProducer liquibaseProducer = (LiquibaseFactoryProducer)Arc.container().instance(LiquibaseFactoryProducer.class, new Annotation[0]).get();
        final LiquibaseFactory liquibaseFactory = liquibaseProducer.createLiquibaseFactory((DataSource)dataSource, dataSourceName);
        return new Supplier<LiquibaseFactory>(){

            @Override
            public LiquibaseFactory get() {
                return liquibaseFactory;
            }
        };
    }

    public void doStartActions() {
        try {
            InjectableInstance liquibaseFactoryInstance = Arc.container().select(LiquibaseFactory.class, new Annotation[]{Any.Literal.INSTANCE});
            if (liquibaseFactoryInstance.isUnsatisfied()) {
                return;
            }
            for (InstanceHandle liquibaseFactoryHandle : liquibaseFactoryInstance.handles()) {
                try {
                    LiquibaseFactory liquibaseFactory = (LiquibaseFactory)liquibaseFactoryHandle.get();
                    LiquibaseConfig config = liquibaseFactory.getConfiguration();
                    if (!config.cleanAtStart && !config.migrateAtStart) continue;
                    Liquibase liquibase = liquibaseFactory.createLiquibase();
                    try {
                        if (config.cleanAtStart) {
                            liquibase.dropAll();
                        }
                        if (!config.migrateAtStart) continue;
                        if (config.validateOnMigrate) {
                            liquibase.validate();
                        }
                        liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
                    }
                    finally {
                        if (liquibase == null) continue;
                        liquibase.close();
                    }
                }
                catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {}
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting Liquibase", e);
        }
    }
}

