/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.agroal.runtime.UnconfiguredDataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseConfig;
import io.quarkus.liquibase.runtime.LiquibaseFactoryProducer;
import io.quarkus.liquibase.runtime.LiquibaseRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;

@Recorder
public class LiquibaseRecorder {
    private final RuntimeValue<LiquibaseRuntimeConfig> config;

    public LiquibaseRecorder(RuntimeValue<LiquibaseRuntimeConfig> config) {
        this.config = config;
    }

    public Function<SyntheticCreationalContext<LiquibaseFactory>, LiquibaseFactory> liquibaseFunction(String dataSourceName) {
        AgroalDataSource dataSource = DataSources.fromName((String)dataSourceName);
        if (dataSource instanceof UnconfiguredDataSource) {
            return new Function<SyntheticCreationalContext<LiquibaseFactory>, LiquibaseFactory>(){

                @Override
                public LiquibaseFactory apply(SyntheticCreationalContext<LiquibaseFactory> context) {
                    throw new UnsatisfiedResolutionException("No datasource has been configured");
                }
            };
        }
        return new Function<SyntheticCreationalContext<LiquibaseFactory>, LiquibaseFactory>((DataSource)dataSource, dataSourceName){
            final /* synthetic */ DataSource val$dataSource;
            final /* synthetic */ String val$dataSourceName;
            {
                this.val$dataSource = dataSource;
                this.val$dataSourceName = string;
            }

            @Override
            public LiquibaseFactory apply(SyntheticCreationalContext<LiquibaseFactory> context) {
                LiquibaseFactoryProducer liquibaseProducer = (LiquibaseFactoryProducer)context.getInjectedReference(LiquibaseFactoryProducer.class, new Annotation[0]);
                LiquibaseFactory liquibaseFactory = liquibaseProducer.createLiquibaseFactory(this.val$dataSource, this.val$dataSourceName);
                return liquibaseFactory;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStartActions() {
        if (!((LiquibaseRuntimeConfig)this.config.getValue()).enabled) {
            return;
        }
        try {
            InjectableInstance liquibaseFactoryInstance = Arc.container().select(LiquibaseFactory.class, new Annotation[]{Any.Literal.INSTANCE});
            if (liquibaseFactoryInstance.isUnsatisfied()) {
                return;
            }
            for (InstanceHandle liquibaseFactoryHandle : liquibaseFactoryInstance.handles()) {
                try {
                    LiquibaseFactory liquibaseFactory = (LiquibaseFactory)liquibaseFactoryHandle.get();
                    LiquibaseConfig config = liquibaseFactory.getConfiguration();
                    if (!config.cleanAtStart && !config.migrateAtStart) continue;
                    Liquibase liquibase = liquibaseFactory.createLiquibase();
                    try {
                        if (config.cleanAtStart) {
                            liquibase.dropAll();
                        }
                        if (!config.migrateAtStart) continue;
                        LockService lockService = LockServiceFactory.getInstance().getLockService(liquibase.getDatabase());
                        lockService.waitForLock();
                        try {
                            if (config.validateOnMigrate) {
                                liquibase.validate();
                            }
                            liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
                        }
                        finally {
                            lockService.releaseLock();
                        }
                    }
                    finally {
                        if (liquibase == null) continue;
                        liquibase.close();
                    }
                }
                catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {}
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting Liquibase", e);
        }
    }
}

