/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase;

import io.quarkus.liquibase.runtime.LiquibaseConfig;
import io.quarkus.runtime.util.StringUtil;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class LiquibaseFactory {
    private final DataSource dataSource;
    private final String dataSourceName;
    private final LiquibaseConfig config;

    public LiquibaseFactory(LiquibaseConfig config, DataSource datasource, String dataSourceName) {
        this.config = config;
        this.dataSource = datasource;
        this.dataSourceName = dataSourceName;
    }

    private ResourceAccessor resolveResourceAccessor() throws FileNotFoundException {
        CompositeResourceAccessor compositeResourceAccessor = new CompositeResourceAccessor(new ResourceAccessor[0]);
        compositeResourceAccessor.addResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor(Thread.currentThread().getContextClassLoader()));
        if (!this.config.changeLog.startsWith("filesystem:") && this.config.searchPath.isEmpty()) {
            return compositeResourceAccessor;
        }
        if (this.config.searchPath.isEmpty()) {
            compositeResourceAccessor.addResourceAccessor((ResourceAccessor)new DirectoryResourceAccessor(Paths.get(StringUtil.changePrefix((String)this.config.changeLog, (String)"filesystem:", (String)""), new String[0]).getParent()));
            return compositeResourceAccessor;
        }
        for (String searchPath : this.config.searchPath.get()) {
            compositeResourceAccessor.addResourceAccessor((ResourceAccessor)new DirectoryResourceAccessor(Paths.get(searchPath, new String[0])));
        }
        return compositeResourceAccessor;
    }

    private String parseChangeLog(String changeLog) {
        if (changeLog.startsWith("filesystem:") && this.config.searchPath.isEmpty()) {
            return Paths.get(StringUtil.changePrefix((String)changeLog, (String)"filesystem:", (String)""), new String[0]).getFileName().toString();
        }
        if (changeLog.startsWith("filesystem:")) {
            return StringUtil.changePrefix((String)changeLog, (String)"filesystem:", (String)"");
        }
        if (changeLog.startsWith("classpath:")) {
            return StringUtil.changePrefix((String)changeLog, (String)"classpath:", (String)"");
        }
        return changeLog;
    }

    public Liquibase createLiquibase() {
        Liquibase liquibase;
        block12: {
            ResourceAccessor resourceAccessor = this.resolveResourceAccessor();
            try {
                String parsedChangeLog = this.parseChangeLog(this.config.changeLog);
                Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.dataSource.getConnection()));
                if (database != null) {
                    database.setDatabaseChangeLogLockTableName(this.config.databaseChangeLogLockTableName);
                    database.setDatabaseChangeLogTableName(this.config.databaseChangeLogTableName);
                    this.config.liquibaseCatalogName.ifPresent(arg_0 -> ((Database)database).setLiquibaseCatalogName(arg_0));
                    this.config.liquibaseSchemaName.ifPresent(arg_0 -> ((Database)database).setLiquibaseSchemaName(arg_0));
                    this.config.liquibaseTablespaceName.ifPresent(arg_0 -> ((Database)database).setLiquibaseTablespaceName(arg_0));
                    if (this.config.defaultCatalogName.isPresent()) {
                        database.setDefaultCatalogName(this.config.defaultCatalogName.get());
                    }
                    if (this.config.defaultSchemaName.isPresent()) {
                        database.setDefaultSchemaName(this.config.defaultSchemaName.get());
                    }
                }
                Liquibase liquibase2 = new Liquibase(parsedChangeLog, resourceAccessor, database);
                for (Map.Entry<String, String> entry : this.config.changeLogParameters.entrySet()) {
                    liquibase2.getChangeLogParameters().set(entry.getKey(), (Object)entry.getValue());
                }
                liquibase = liquibase2;
                if (resourceAccessor == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAccessor != null) {
                        try {
                            resourceAccessor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
            resourceAccessor.close();
        }
        return liquibase;
    }

    public LiquibaseConfig getConfiguration() {
        return this.config;
    }

    public LabelExpression createLabels() {
        return new LabelExpression(this.config.labels);
    }

    public Contexts createContexts() {
        return new Contexts(this.config.contexts);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }
}

