/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.agroal.runtime.UnconfiguredDataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseConfig;
import io.quarkus.liquibase.runtime.LiquibaseFactoryProducer;
import io.quarkus.liquibase.runtime.LiquibaseFactoryUtil;
import io.quarkus.liquibase.runtime.LiquibaseRuntimeConfig;
import io.quarkus.runtime.ResettableSystemProperties;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.function.Function;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;

@Recorder
public class LiquibaseRecorder {
    private final RuntimeValue<LiquibaseRuntimeConfig> config;

    public LiquibaseRecorder(RuntimeValue<LiquibaseRuntimeConfig> config) {
        this.config = config;
    }

    public Function<SyntheticCreationalContext<LiquibaseFactory>, LiquibaseFactory> liquibaseFunction(final String dataSourceName) {
        return new Function<SyntheticCreationalContext<LiquibaseFactory>, LiquibaseFactory>(){

            @Override
            public LiquibaseFactory apply(SyntheticCreationalContext<LiquibaseFactory> context) {
                AgroalDataSource dataSource;
                try {
                    dataSource = ((DataSources)context.getInjectedReference(DataSources.class, new Annotation[0])).getDataSource(dataSourceName);
                    if (dataSource instanceof UnconfiguredDataSource) {
                        throw DataSourceUtil.dataSourceNotConfigured((String)dataSourceName);
                    }
                }
                catch (RuntimeException e) {
                    throw new UnsatisfiedResolutionException(String.format(Locale.ROOT, "Unable to find datasource '%s' for Liquibase: %s", dataSourceName, e.getMessage()), (Throwable)e);
                }
                LiquibaseFactoryProducer liquibaseProducer = (LiquibaseFactoryProducer)context.getInjectedReference(LiquibaseFactoryProducer.class, new Annotation[0]);
                return liquibaseProducer.createLiquibaseFactory((DataSource)dataSource, dataSourceName);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStartActions(String dataSourceName) {
        block23: {
            if (!((LiquibaseRuntimeConfig)this.config.getValue()).enabled) {
                return;
            }
            if (!((DataSources)Arc.container().instance(DataSources.class, new Annotation[0]).get()).getActiveDataSourceNames().contains(dataSourceName)) {
                return;
            }
            InstanceHandle<LiquibaseFactory> liquibaseFactoryHandle = LiquibaseFactoryUtil.getLiquibaseFactory(dataSourceName);
            try {
                LiquibaseFactory liquibaseFactory = (LiquibaseFactory)liquibaseFactoryHandle.get();
                LiquibaseConfig config = liquibaseFactory.getConfiguration();
                if (!config.cleanAtStart && !config.migrateAtStart) {
                    return;
                }
                try (Liquibase liquibase = liquibaseFactory.createLiquibase();
                     ResettableSystemProperties resettableSystemProperties = liquibaseFactory.createResettableSystemProperties();){
                    if (config.cleanAtStart) {
                        liquibase.dropAll();
                    }
                    if (!config.migrateAtStart) break block23;
                    LockService lockService = LockServiceFactory.getInstance().getLockService(liquibase.getDatabase());
                    lockService.waitForLock();
                    try {
                        if (config.validateOnMigrate) {
                            liquibase.validate();
                        }
                        liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
                    }
                    finally {
                        lockService.releaseLock();
                    }
                }
            }
            catch (UnsatisfiedResolutionException liquibaseFactory) {
            }
            catch (Exception e) {
                throw new IllegalStateException("Error starting Liquibase", e);
            }
        }
    }
}

