/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseConfig;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceBuildTimeConfig;
import io.quarkus.liquibase.runtime.LiquibaseDataSourceRuntimeConfig;
import javax.sql.DataSource;

class LiquibaseCreator {
    private final LiquibaseDataSourceRuntimeConfig liquibaseRuntimeConfig;
    private final LiquibaseDataSourceBuildTimeConfig liquibaseBuildTimeConfig;

    public LiquibaseCreator(LiquibaseDataSourceRuntimeConfig liquibaseRuntimeConfig, LiquibaseDataSourceBuildTimeConfig liquibaseBuildTimeConfig) {
        this.liquibaseRuntimeConfig = liquibaseRuntimeConfig;
        this.liquibaseBuildTimeConfig = liquibaseBuildTimeConfig;
    }

    public LiquibaseFactory createLiquibaseFactory(DataSource dataSource, String dataSourceName) {
        LiquibaseConfig config = new LiquibaseConfig();
        config.changeLog = this.liquibaseBuildTimeConfig.changeLog();
        config.searchPath = this.liquibaseBuildTimeConfig.searchPath();
        config.changeLogParameters = this.liquibaseRuntimeConfig.changeLogParameters();
        if (this.liquibaseRuntimeConfig.labels().isPresent()) {
            config.labels = this.liquibaseRuntimeConfig.labels().get();
        }
        if (this.liquibaseRuntimeConfig.contexts().isPresent()) {
            config.contexts = this.liquibaseRuntimeConfig.contexts().get();
        }
        config.databaseChangeLogLockTableName = this.liquibaseRuntimeConfig.databaseChangeLogLockTableName();
        config.databaseChangeLogTableName = this.liquibaseRuntimeConfig.databaseChangeLogTableName();
        config.password = this.liquibaseRuntimeConfig.password();
        config.username = this.liquibaseRuntimeConfig.username();
        config.defaultSchemaName = this.liquibaseRuntimeConfig.defaultSchemaName();
        config.defaultCatalogName = this.liquibaseRuntimeConfig.defaultCatalogName();
        config.liquibaseTablespaceName = this.liquibaseRuntimeConfig.liquibaseTablespaceName();
        config.liquibaseSchemaName = this.liquibaseRuntimeConfig.liquibaseSchemaName();
        config.liquibaseCatalogName = this.liquibaseRuntimeConfig.liquibaseCatalogName();
        config.migrateAtStart = this.liquibaseRuntimeConfig.migrateAtStart();
        config.cleanAtStart = this.liquibaseRuntimeConfig.cleanAtStart();
        config.validateOnMigrate = this.liquibaseRuntimeConfig.validateOnMigrate();
        config.allowDuplicatedChangesetIdentifiers = this.liquibaseRuntimeConfig.allowDuplicatedChangesetIdentifiers();
        return new LiquibaseFactory(config, dataSource, dataSourceName);
    }
}

