/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime.devconsole;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.runtime.spi.FlashScopeUtil;
import io.quarkus.liquibase.LiquibaseDataSource;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import liquibase.Liquibase;

@Recorder
public class LiquibaseDevConsoleRecorder {
    public Handler<RoutingContext> handler() {
        return new DevConsolePostHandler(){

            protected void handlePost(RoutingContext event, MultiMap form) throws Exception {
                String datasource = form.get("datasource");
                String operation = form.get("operation");
                InjectableInstance liquibaseFactoryInstance = Arc.container().select(LiquibaseFactory.class, new Annotation[0]);
                if (liquibaseFactoryInstance.isUnsatisfied()) {
                    return;
                }
                Object qualifier = DataSourceUtil.isDefault((String)datasource) ? Default.Literal.INSTANCE : LiquibaseDataSource.LiquibaseDataSourceLiteral.of(datasource);
                InstanceHandle liquibaseFactoryHandle = Arc.container().instance(LiquibaseFactory.class, new Annotation[]{qualifier});
                if (!liquibaseFactoryHandle.isAvailable()) {
                    this.flashMessage(event, "Unknown datasource: " + datasource, FlashScopeUtil.FlashMessageStatus.ERROR);
                }
                LiquibaseFactory liquibaseFactory = (LiquibaseFactory)liquibaseFactoryHandle.get();
                if ("clean".equals(operation)) {
                    try (Liquibase liquibase = liquibaseFactory.createLiquibase();){
                        liquibase.dropAll();
                    }
                    this.flashMessage(event, "Datasource " + datasource + " cleaned");
                    return;
                }
                if ("migrate".equals(operation)) {
                    try (Liquibase liquibase = liquibaseFactory.createLiquibase();){
                        liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
                    }
                    this.flashMessage(event, "Datasource " + datasource + " migrated");
                    return;
                }
                this.flashMessage(event, "Invalid operation: " + operation, FlashScopeUtil.FlashMessageStatus.ERROR);
            }
        };
    }
}

