/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime.dev.ui;

import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.dev.ui.LiquibaseFactoriesSupplier;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collection;
import liquibase.Liquibase;

@ApplicationScoped
public class LiquibaseJsonRpcService {
    private Collection<LiquibaseFactory> factories;

    @PostConstruct
    void init() {
        this.factories = new LiquibaseFactoriesSupplier().get();
    }

    public boolean clear(String ds) throws Exception {
        for (LiquibaseFactory lf : this.factories) {
            if (!ds.equalsIgnoreCase(lf.getDataSourceName())) continue;
            try (Liquibase liquibase = lf.createLiquibase();){
                liquibase.dropAll();
            }
            return true;
        }
        return false;
    }

    public boolean migrate(String ds) throws Exception {
        for (LiquibaseFactory lf : this.factories) {
            if (!ds.equalsIgnoreCase(lf.getDataSourceName())) continue;
            try (Liquibase liquibase = lf.createLiquibase();){
                liquibase.update(lf.createContexts(), lf.createLabels());
            }
            return true;
        }
        return false;
    }

    public Integer getDatasourceCount() {
        return this.factories.size();
    }

    public Collection<LiquibaseFactory> getLiquibaseFactories() {
        return this.factories;
    }
}

