/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.runtime.DatabaseSchemaProvider;
import io.quarkus.liquibase.LiquibaseFactory;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import java.lang.annotation.Annotation;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;

public class LiquibaseSchemaProvider
implements DatabaseSchemaProvider {
    public void resetDatabase(String dbName) {
        try {
            InjectableInstance liquibaseFactoryInstance = Arc.container().select(LiquibaseFactory.class, new Annotation[]{Any.Literal.INSTANCE});
            if (liquibaseFactoryInstance.isUnsatisfied()) {
                return;
            }
            for (InstanceHandle liquibaseFactoryHandle : liquibaseFactoryInstance.handles()) {
                try {
                    LiquibaseFactory liquibaseFactory = (LiquibaseFactory)liquibaseFactoryHandle.get();
                    if (!liquibaseFactory.getDataSourceName().equals(dbName)) continue;
                    this.doReset(liquibaseFactory);
                }
                catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {}
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting Liquibase", e);
        }
    }

    public void resetAllDatabases() {
        try {
            InjectableInstance liquibaseFactoryInstance = Arc.container().select(LiquibaseFactory.class, new Annotation[]{Any.Literal.INSTANCE});
            if (liquibaseFactoryInstance.isUnsatisfied()) {
                return;
            }
            for (InstanceHandle liquibaseFactoryHandle : liquibaseFactoryInstance.handles()) {
                try {
                    LiquibaseFactory liquibaseFactory = (LiquibaseFactory)liquibaseFactoryHandle.get();
                    this.doReset(liquibaseFactory);
                }
                catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {}
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting Liquibase", e);
        }
    }

    public void doReset(LiquibaseFactory liquibaseFactory) throws LiquibaseException {
        try (Liquibase liquibase = liquibaseFactory.createLiquibase();){
            liquibase.dropAll();
        }
        liquibase = liquibaseFactory.createLiquibase();
        try {
            liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
        }
        finally {
            if (liquibase != null) {
                liquibase.close();
            }
        }
    }
}

