/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.load.shedding.runtime;

import io.quarkus.load.shedding.RequestPrioritizer;
import io.quarkus.load.shedding.RequestPriority;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.vertx.core.http.HttpServerRequest;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
public class ManagementRequestPrioritizer
implements RequestPrioritizer<HttpServerRequest> {
    private final String managementPath;

    @Inject
    public ManagementRequestPrioritizer(HttpBuildTimeConfig httpConfig, ManagementInterfaceBuildTimeConfig managementInterfaceConfig) {
        if (managementInterfaceConfig.enabled) {
            this.managementPath = null;
            return;
        }
        if (httpConfig.nonApplicationRootPath.startsWith("/")) {
            if (httpConfig.nonApplicationRootPath.equals(httpConfig.rootPath)) {
                this.managementPath = null;
                return;
            }
            this.managementPath = httpConfig.nonApplicationRootPath;
            return;
        }
        this.managementPath = httpConfig.rootPath + httpConfig.nonApplicationRootPath;
    }

    @Override
    public boolean appliesTo(Object request) {
        if (this.managementPath != null && request instanceof HttpServerRequest) {
            HttpServerRequest httpRequest = (HttpServerRequest)request;
            return httpRequest.path().startsWith(this.managementPath);
        }
        return false;
    }

    @Override
    public RequestPriority priority(HttpServerRequest request) {
        return RequestPriority.CRITICAL;
    }
}

