/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.load.shedding.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.load.shedding.runtime.LoadSheddingRuntimeConfig;
import io.quarkus.load.shedding.runtime.OverloadDetector;
import io.quarkus.load.shedding.runtime.PriorityLoadShedding;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.Router;
import jakarta.annotation.Priority;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Singleton;

@Singleton
public class HttpLoadShedding {
    public void init(@Observes @Priority(value=-1000000000) Router router, final OverloadDetector detector, PriorityLoadShedding priority, LoadSheddingRuntimeConfig config) {
        if (!config.enabled()) {
            return;
        }
        router.route().order(-1000000000).handler(ctx -> {
            if (detector.isOverloaded() && priority.shedLoad(ctx.request())) {
                HttpServerResponse response = ctx.response();
                response.setStatusCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code());
                response.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)"close");
                response.endHandler((Handler)new Handler<Void>(){

                    public void handle(Void ignored) {
                        ctx.request().connection().close();
                    }
                });
                response.end();
            } else {
                detector.requestBegin();
                final long start = System.nanoTime();
                ctx.addEndHandler((Handler)new Handler<AsyncResult<Void>>(){

                    public void handle(AsyncResult<Void> ignored) {
                        long end = System.nanoTime();
                        detector.requestEnd((end - start) / 1000L);
                    }
                });
                ctx.next();
            }
        });
    }
}

