/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.load.shedding.runtime;

import io.quarkus.load.shedding.runtime.LoadSheddingRuntimeConfig;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
public class OverloadDetector {
    private static final int[] LOG10_PLUS_1_TABLE = new int[1000];
    private final int maxLimit;
    private final int alphaFactor;
    private final int betaFactor;
    private final double probeFactor;
    private final AtomicInteger currentRequests = new AtomicInteger();
    private volatile long currentLimit;
    private long lowestRequestTime = Long.MAX_VALUE;
    private double probeCount = 0.0;
    private double probeJitter;

    @Inject
    public OverloadDetector(LoadSheddingRuntimeConfig config) {
        this.maxLimit = config.maxLimit();
        this.alphaFactor = config.alphaFactor();
        this.betaFactor = config.betaFactor();
        this.probeFactor = config.probeFactor();
        this.currentLimit = config.initialLimit();
        this.resetProbeJitter();
    }

    public boolean isOverloaded() {
        return (long)this.currentRequests.get() >= this.currentLimit;
    }

    public void requestBegin() {
        this.currentRequests.incrementAndGet();
    }

    public void requestEnd(long timeInMicros) {
        int current = this.currentRequests.getAndDecrement();
        this.update(timeInMicros, current);
    }

    private synchronized void update(long requestTime, int currentRequests) {
        long newLimit;
        this.probeCount += 1.0;
        if (this.probeFactor * this.probeJitter * (double)this.currentLimit <= this.probeCount) {
            this.resetProbeJitter();
            this.probeCount = 0.0;
            this.lowestRequestTime = requestTime;
            return;
        }
        if (requestTime < this.lowestRequestTime) {
            this.lowestRequestTime = requestTime;
            return;
        }
        long currentLimit = this.currentLimit;
        if (2L * (long)currentRequests < currentLimit) {
            return;
        }
        int queueSize = (int)Math.ceil((double)currentLimit * (1.0 - (double)this.lowestRequestTime / (double)requestTime));
        int currentLimitLog10Plus1 = currentLimit >= 0L && currentLimit < 1000L ? LOG10_PLUS_1_TABLE[(int)currentLimit] : 1 + (int)Math.log10(currentLimit);
        int alpha = this.alphaFactor * currentLimitLog10Plus1;
        int beta = this.betaFactor * currentLimitLog10Plus1;
        if (queueSize <= currentLimitLog10Plus1) {
            newLimit = currentLimit + (long)beta;
        } else if (queueSize < alpha) {
            newLimit = currentLimit + (long)currentLimitLog10Plus1;
        } else if (queueSize > beta) {
            newLimit = currentLimit - (long)currentLimitLog10Plus1;
        } else {
            return;
        }
        this.currentLimit = newLimit = Math.max(1L, Math.min((long)this.maxLimit, newLimit));
    }

    private void resetProbeJitter() {
        this.probeJitter = ThreadLocalRandom.current().nextDouble(0.5, 1.0);
    }

    static {
        OverloadDetector.LOG10_PLUS_1_TABLE[0] = 1;
        for (int i = 1; i < 1000; ++i) {
            OverloadDetector.LOG10_PLUS_1_TABLE[i] = 1 + (int)Math.log10(i);
        }
    }
}

