/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.load.shedding.runtime;

import io.quarkus.load.shedding.RequestPrioritizer;
import io.quarkus.load.shedding.RequestPriority;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.vertx.core.http.HttpServerRequest;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
public class ManagementRequestPrioritizer
implements RequestPrioritizer<HttpServerRequest> {
    private final String managementPath;

    @Inject
    public ManagementRequestPrioritizer(VertxHttpBuildTimeConfig buildTimeConfig, ManagementInterfaceBuildTimeConfig managementBuildTimeConfig) {
        if (managementBuildTimeConfig.enabled()) {
            this.managementPath = null;
            return;
        }
        if (buildTimeConfig.nonApplicationRootPath().startsWith("/")) {
            if (buildTimeConfig.nonApplicationRootPath().equals(buildTimeConfig.rootPath())) {
                this.managementPath = null;
                return;
            }
            this.managementPath = buildTimeConfig.nonApplicationRootPath();
            return;
        }
        this.managementPath = buildTimeConfig.rootPath() + buildTimeConfig.nonApplicationRootPath();
    }

    @Override
    public boolean appliesTo(Object request) {
        if (this.managementPath != null && request instanceof HttpServerRequest) {
            HttpServerRequest httpRequest = (HttpServerRequest)request;
            return httpRequest.path().startsWith(this.managementPath);
        }
        return false;
    }

    @Override
    public RequestPriority priority(HttpServerRequest request) {
        return RequestPriority.CRITICAL;
    }
}

