/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.logging.json.runtime;

import io.quarkus.logging.json.runtime.AdditionalFieldConfig;
import io.quarkus.logging.json.runtime.JsonConfig;
import io.quarkus.logging.json.runtime.JsonFormatter;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Formatter;

@Recorder
public class LoggingJsonRecorder {
    public RuntimeValue<Optional<Formatter>> initializeJsonLogging(JsonConfig config) {
        if (!config.enable) {
            return new RuntimeValue(Optional.empty());
        }
        JsonFormatter formatter = config.keyOverrides.map(ko -> new JsonFormatter((String)ko)).orElse(new JsonFormatter());
        config.excludedKeys.ifPresent(ek -> formatter.setExcludedKeys((Set<String>)ek));
        Optional.ofNullable(config.additionalField).ifPresent(af -> formatter.setAdditionalFields((Map<String, AdditionalFieldConfig>)af));
        formatter.setPrettyPrint(config.prettyPrint);
        String dateFormat = config.dateFormat;
        if (!dateFormat.equals("default")) {
            formatter.setDateFormat(dateFormat);
        }
        formatter.setExceptionOutputType(config.exceptionOutputType);
        formatter.setPrintDetails(config.printDetails);
        config.recordDelimiter.ifPresent(arg_0 -> ((JsonFormatter)formatter).setRecordDelimiter(arg_0));
        String zoneId = config.zoneId;
        if (!zoneId.equals("default")) {
            formatter.setZoneId(zoneId);
        }
        return new RuntimeValue(Optional.of(formatter));
    }
}

