/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.logging.sentry;

import io.quarkus.logging.sentry.SentryConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.sentry.Sentry;
import io.sentry.SentryOptions;
import io.sentry.jul.SentryHandler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Handler;
import org.jboss.logging.Logger;

@Recorder
public class SentryHandlerValueFactory {
    private static final Logger LOG = Logger.getLogger(SentryHandlerValueFactory.class);

    public RuntimeValue<Optional<Handler>> create(SentryConfig config) {
        if (!config.enable) {
            return new RuntimeValue(Optional.empty());
        }
        SentryOptions options = SentryHandlerValueFactory.toSentryOptions(config);
        Sentry.init((SentryOptions)options);
        SentryHandler handler = new SentryHandler(options);
        handler.setLevel(config.level);
        handler.setPrintfStyle(true);
        handler.setMinimumEventLevel(config.minimumEventLevel != null ? config.minimumEventLevel : config.level);
        handler.setMinimumBreadcrumbLevel(config.minimumBreadcrumbLevel);
        return new RuntimeValue(Optional.of(handler));
    }

    public static SentryOptions toSentryOptions(SentryConfig sentryConfig) {
        SentryOptions options;
        block5: {
            List<String> inAppPackages;
            block6: {
                block4: {
                    if (!sentryConfig.dsn.isPresent()) {
                        throw new ConfigurationException("Configuration key \"quarkus.log.sentry.dsn\" is required when Sentry is enabled, but its value is empty/missing");
                    }
                    options = new SentryOptions();
                    if (sentryConfig.inAppPackages.isPresent()) break block4;
                    LOG.warn((Object)"No 'quarkus.sentry.in-app-packages' was configured, this option is highly recommended as it affects stacktrace grouping and display on Sentry. See https://quarkus.io/guides/logging-sentry#in-app-packages");
                    break block5;
                }
                inAppPackages = sentryConfig.inAppPackages.get();
                if (inAppPackages.size() != 1) break block6;
                if (Objects.equals(inAppPackages.get(0), "*")) break block5;
            }
            inAppPackages.forEach(arg_0 -> ((SentryOptions)options).addInAppInclude(arg_0));
        }
        options.setDsn(sentryConfig.dsn.get());
        sentryConfig.environment.ifPresent(arg_0 -> ((SentryOptions)options).setEnvironment(arg_0));
        sentryConfig.release.ifPresent(arg_0 -> ((SentryOptions)options).setRelease(arg_0));
        sentryConfig.serverName.ifPresent(arg_0 -> ((SentryOptions)options).setServerName(arg_0));
        options.setDebug(Boolean.valueOf(sentryConfig.debug));
        return options;
    }
}

