/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.mailer.MailTemplate;
import io.quarkus.mailer.deployment.MailTemplateInstanceAdaptor;
import io.quarkus.mailer.runtime.BlockingMailerImpl;
import io.quarkus.mailer.runtime.MailClientProducer;
import io.quarkus.mailer.runtime.MailTemplateProducer;
import io.quarkus.mailer.runtime.MailerSupportProducer;
import io.quarkus.mailer.runtime.MockMailboxImpl;
import io.quarkus.mailer.runtime.MutinyMailerImpl;
import io.quarkus.mailer.runtime.ReactiveMailerImpl;
import io.quarkus.qute.deployment.CheckedTemplateAdapter;
import io.quarkus.qute.deployment.CheckedTemplateAdapterBuildItem;
import io.quarkus.qute.deployment.QuteProcessor;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;

public class MailerProcessor {
    private static final DotName MAIL_TEMPLATE = DotName.createSimple((String)MailTemplate.class.getName());

    @BuildStep
    void unremoveableBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(MailClientProducer.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(MailerSupportProducer.class));
    }

    @BuildStep
    AdditionalBeanBuildItem registerMailers() {
        return AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{ReactiveMailerImpl.class, MutinyMailerImpl.class, BlockingMailerImpl.class, MockMailboxImpl.class, MailTemplateProducer.class}).build();
    }

    @BuildStep
    CheckedTemplateAdapterBuildItem registerCheckedTemplateAdaptor() {
        return new CheckedTemplateAdapterBuildItem((CheckedTemplateAdapter)new MailTemplateInstanceAdaptor());
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(Feature.MAILER);
    }

    @BuildStep
    void registerAuthClass(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"io.vertx.ext.mail.impl.sasl.AuthDigestMD5", "io.vertx.ext.mail.impl.sasl.AuthCramSHA256", "io.vertx.ext.mail.impl.sasl.AuthCramSHA1", "io.vertx.ext.mail.impl.sasl.AuthCramMD5", "io.vertx.ext.mail.impl.sasl.AuthDigestMD5", "io.vertx.ext.mail.impl.sasl.AuthPlain", "io.vertx.ext.mail.impl.sasl.AuthLogin"}));
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.MAILER);
    }

    @BuildStep
    void validateMailTemplates(List<TemplatePathBuildItem> templatePaths, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        HashSet<String> filePaths = new HashSet<String>();
        for (TemplatePathBuildItem templatePath : templatePaths) {
            String filePath = templatePath.getPath();
            if (File.separatorChar != '/') {
                filePath = filePath.replace(File.separatorChar, '/');
            }
            if (!filePath.endsWith("html") && !filePath.endsWith("htm") && !filePath.endsWith("txt")) continue;
            filePaths.add(filePath);
            int idx = filePath.lastIndexOf(46);
            if (idx == -1) continue;
            filePaths.add(filePath.substring(0, idx));
        }
        for (InjectionPointInfo injectionPoint : (Collection)validationPhase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
            AnnotationInstance resourcePath;
            String name;
            if (!injectionPoint.getRequiredType().name().equals((Object)MAIL_TEMPLATE) || (name = (resourcePath = injectionPoint.getRequiredQualifier(QuteProcessor.RESOURCE_PATH)) != null ? resourcePath.value().asString() : (injectionPoint.hasDefaultedQualifier() ? QuteProcessor.getName((InjectionPointInfo)injectionPoint) : null)) == null || !filePaths.stream().noneMatch(path -> path.endsWith(name))) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("No mail template found for " + injectionPoint.getTargetInfo())}));
        }
    }
}

