/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.mailer.MailTemplate;
import io.quarkus.mailer.Mailer;
import io.quarkus.mailer.MailerName;
import io.quarkus.mailer.MockMailbox;
import io.quarkus.mailer.deployment.MailTemplateInstanceAdaptor;
import io.quarkus.mailer.deployment.MailTemplateMailerNameTransformer;
import io.quarkus.mailer.deployment.MailersBuildItem;
import io.quarkus.mailer.reactive.ReactiveMailer;
import io.quarkus.mailer.runtime.MailTemplateMailerName;
import io.quarkus.mailer.runtime.MailTemplateProducer;
import io.quarkus.mailer.runtime.MailerRecorder;
import io.quarkus.mailer.runtime.MailerSupport;
import io.quarkus.mailer.runtime.Mailers;
import io.quarkus.mailer.runtime.MailersBuildTimeConfig;
import io.quarkus.mailer.runtime.MailersRuntimeConfig;
import io.quarkus.qute.CheckedTemplate;
import io.quarkus.qute.deployment.CheckedTemplateAdapter;
import io.quarkus.qute.deployment.CheckedTemplateAdapterBuildItem;
import io.quarkus.qute.deployment.QuteProcessor;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import io.vertx.ext.mail.MailClient;
import jakarta.enterprise.inject.Default;
import jakarta.inject.Singleton;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class MailerProcessor {
    static final DotName MAIL_TEMPLATE = DotName.createSimple((String)MailTemplate.class.getName());
    static final DotName MAILER_NAME = DotName.createSimple(MailerName.class);
    static final DotName MAIL_TEMPLATE_MAILER_NAME = DotName.createSimple(MailTemplateMailerName.class);
    private static final List<DotName> SUPPORTED_INJECTION_TYPES = List.of(DotName.createSimple(Mailer.class), DotName.createSimple(ReactiveMailer.class), DotName.createSimple(MockMailbox.class), DotName.createSimple(MailClient.class), DotName.createSimple(io.vertx.mutiny.ext.mail.MailClient.class), MAIL_TEMPLATE);

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{Mailers.class}).build());
        beans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{MailTemplateProducer.class}).build());
        beans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(MailerName.class).build());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    MailersBuildItem generateMailerSupportBean(MailerRecorder recorder, CombinedIndexBuildItem index, BeanDiscoveryFinishedBuildItem beans, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        List mailerInjectionPoints = beans.getInjectionPoints().stream().filter(i -> SUPPORTED_INJECTION_TYPES.contains(i.getRequiredType().name())).collect(Collectors.toList());
        boolean hasDefaultMailer = mailerInjectionPoints.stream().anyMatch(i -> i.hasDefaultedQualifier()) || !index.getIndex().getAnnotations(CheckedTemplate.class).isEmpty();
        Set<String> namedMailers = mailerInjectionPoints.stream().map(i -> i.getRequiredQualifier(MAILER_NAME)).filter(ai -> ai != null).map(ai -> ai.value().asString()).collect(Collectors.toSet());
        MailerSupport mailerSupport = new MailerSupport(hasDefaultMailer, namedMailers);
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MailerSupport.class).supplier(recorder.mailerSupportSupplier(mailerSupport)).scope(Singleton.class)).unremovable()).done());
        return new MailersBuildItem(hasDefaultMailer, namedMailers);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateMailerBeans(MailerRecorder recorder, MailersBuildItem mailers, MailersRuntimeConfig mailersRuntimeConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        if (mailers.hasDefaultMailer()) {
            this.generateMailerBeansForName("<default>", recorder, mailersRuntimeConfig, syntheticBeans);
        }
        for (String name : mailers.getNamedMailers()) {
            this.generateMailerBeansForName(name, recorder, mailersRuntimeConfig, syntheticBeans);
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationsTransformer() {
        return new AnnotationsTransformerBuildItem((AnnotationsTransformer)new MailTemplateMailerNameTransformer());
    }

    private void generateMailerBeansForName(String name, MailerRecorder recorder, MailersRuntimeConfig mailersRuntimeConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        AnnotationInstance qualifier = "<default>".equals(name) ? AnnotationInstance.builder(Default.class).build() : AnnotationInstance.builder((DotName)MAILER_NAME).add("value", name).build();
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MailClient.class).scope(Singleton.class)).qualifiers(new AnnotationInstance[]{qualifier})).unremovable()).defaultBean()).setRuntimeInit().addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(Mailers.class)), new AnnotationInstance[0])).createWith(recorder.mailClientFunction(name, mailersRuntimeConfig)).done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(io.vertx.mutiny.ext.mail.MailClient.class).scope(Singleton.class)).qualifiers(new AnnotationInstance[]{qualifier})).unremovable()).defaultBean()).setRuntimeInit().addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(Mailers.class)), new AnnotationInstance[0])).createWith(recorder.reactiveMailClientFunction(name, mailersRuntimeConfig)).done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(Mailer.class).scope(Singleton.class)).qualifiers(new AnnotationInstance[]{qualifier})).unremovable()).defaultBean()).setRuntimeInit().addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(Mailers.class)), new AnnotationInstance[0])).createWith(recorder.mailerFunction(name, mailersRuntimeConfig)).done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ReactiveMailer.class).scope(Singleton.class)).qualifiers(new AnnotationInstance[]{qualifier})).unremovable()).defaultBean()).setRuntimeInit().addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(Mailers.class)), new AnnotationInstance[0])).createWith(recorder.reactiveMailerFunction(name, mailersRuntimeConfig)).done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MockMailbox.class).scope(Singleton.class)).qualifiers(new AnnotationInstance[]{qualifier})).unremovable()).defaultBean()).setRuntimeInit().addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(Mailers.class)), new AnnotationInstance[0])).createWith(recorder.mockMailboxFunction(name, mailersRuntimeConfig)).done());
    }

    @BuildStep
    CheckedTemplateAdapterBuildItem registerCheckedTemplateAdaptor() {
        return new CheckedTemplateAdapterBuildItem((CheckedTemplateAdapter)new MailTemplateInstanceAdaptor());
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(Feature.MAILER);
    }

    @BuildStep
    NativeImageConfigBuildItem registerAuthClass(CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.vertx.ext.mail.impl.sasl.AuthCram", "io.vertx.ext.mail.impl.sasl.AuthDigest", "io.vertx.ext.mail.impl.sasl.AuthLogin", "io.vertx.ext.mail.impl.sasl.AuthPlain"}).methods().fields().build());
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder();
        builder.addRuntimeInitializedClass("io.vertx.ext.mail.impl.sasl.NTLMEngineImpl");
        return builder.build();
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.MAILER);
    }

    @BuildStep(onlyIf={CacheAttachmentsEnabled.class})
    SystemPropertyBuildItem cacheAttachmentBuildItem() {
        return new SystemPropertyBuildItem("vertx.mail.attachment.cache.file", "true");
    }

    @BuildStep
    void validateMailTemplates(List<TemplatePathBuildItem> templatePaths, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        HashSet<String> filePaths = new HashSet<String>();
        for (TemplatePathBuildItem templatePath : templatePaths) {
            String filePath = templatePath.getPath();
            if (File.separatorChar != '/') {
                filePath = filePath.replace(File.separatorChar, '/');
            }
            if (!filePath.endsWith("html") && !filePath.endsWith("htm") && !filePath.endsWith("txt")) continue;
            filePaths.add(filePath);
            int idx = filePath.lastIndexOf(46);
            if (idx == -1) continue;
            filePaths.add(filePath.substring(0, idx));
        }
        for (InjectionPointInfo injectionPoint : (Collection)validationPhase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
            AnnotationInstance resourcePath;
            String name;
            if (!injectionPoint.getRequiredType().name().equals((Object)MAIL_TEMPLATE) || (name = (resourcePath = injectionPoint.getRequiredQualifier(QuteProcessor.LOCATION)) != null ? resourcePath.value().asString() : (injectionPoint.hasDefaultedQualifier() ? QuteProcessor.getName((InjectionPointInfo)injectionPoint) : null)) == null || !filePaths.stream().noneMatch(path -> path.endsWith(name))) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("No mail template found for " + injectionPoint.getTargetInfo())}));
        }
    }

    public static class CacheAttachmentsEnabled
    implements BooleanSupplier {
        MailersBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.cacheAttachments;
        }
    }
}

