/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.mailer.Mail;
import io.quarkus.mailer.MailTemplate;
import io.quarkus.mailer.runtime.MutinyMailerImpl;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.Variant;
import io.smallrye.mutiny.Uni;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class MailTemplateInstanceImpl
implements MailTemplate.MailTemplateInstance {
    private final MutinyMailerImpl mailer;
    private final TemplateInstance templateInstance;
    private final Map<String, Object> data;
    private Mail mail;

    MailTemplateInstanceImpl(MutinyMailerImpl mailer, TemplateInstance templateInstance) {
        this.mailer = mailer;
        this.templateInstance = templateInstance;
        this.data = new HashMap<String, Object>();
        this.mail = new Mail();
    }

    @Override
    public MailTemplate.MailTemplateInstance mail(Mail mail) {
        this.mail = mail;
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance to(String ... to) {
        this.mail.addTo(to);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance cc(String ... cc) {
        this.mail.addCc(cc);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance bcc(String ... bcc) {
        this.mail.addBcc(bcc);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance subject(String subject) {
        this.mail.setSubject(subject);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance from(String from) {
        this.mail.setFrom(from);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance replyTo(String replyTo) {
        this.mail.setReplyTo(replyTo);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance bounceAddress(String bounceAddress) {
        this.mail.setBounceAddress(bounceAddress);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance addInlineAttachment(String name, File file, String contentType, String contentId) {
        this.mail.addInlineAttachment(name, file, contentType, contentId);
        return this;
    }

    @Override
    public MailTemplate.MailTemplateInstance data(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    @Override
    public Uni<Void> send() {
        Object variantsAttr = this.templateInstance.getAttribute("variants");
        if (variantsAttr != null) {
            ArrayList<Result> results = new ArrayList<Result>();
            List variants = (List)variantsAttr;
            for (final Variant variant : variants) {
                if (!variant.getContentType().equals("text/html") && !variant.getContentType().equals("text/plain")) continue;
                results.add(new Result(variant, (Uni<String>)Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<? extends String>>(){

                    @Override
                    public CompletionStage<? extends String> get() {
                        return MailTemplateInstanceImpl.this.templateInstance.setAttribute("selectedVariant", (Object)variant).data((Object)MailTemplateInstanceImpl.this.data).renderAsync();
                    }
                })));
            }
            if (results.isEmpty()) {
                throw new IllegalStateException("No suitable template variant found");
            }
            List unis = results.stream().map(Result::resolve).collect(Collectors.toList());
            return Uni.combine().all().unis(unis).combinedWith(this.combine(results)).chain((Function)new Function<Mail, Uni<? extends Void>>(){

                @Override
                public Uni<? extends Void> apply(Mail m) {
                    return MailTemplateInstanceImpl.this.mailer.send(m);
                }
            });
        }
        throw new IllegalStateException("No template variant found");
    }

    private Function<List<?>, Mail> combine(final List<Result> results) {
        return new Function<List<?>, Mail>(){

            @Override
            public Mail apply(List<?> resolved) {
                for (int i = 0; i < resolved.size(); ++i) {
                    Result result = (Result)results.get(i);
                    String content = (String)resolved.get(i);
                    if (result.variant.getContentType().equals("text/html")) {
                        MailTemplateInstanceImpl.this.mail.setHtml(content);
                        continue;
                    }
                    if (!result.variant.getContentType().equals("text/plain")) continue;
                    MailTemplateInstanceImpl.this.mail.setText(content);
                }
                return MailTemplateInstanceImpl.this.mail;
            }
        };
    }

    static class Result {
        final Variant variant;
        final Uni<String> value;

        public Result(Variant variant, Uni<String> result) {
            this.variant = variant;
            this.value = result;
        }

        Uni<String> resolve() {
            return this.value;
        }
    }
}

