/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.mailer.MailTemplate;
import io.quarkus.mailer.runtime.MailTemplateInstanceImpl;
import io.quarkus.mailer.runtime.MutinyMailerImpl;
import io.quarkus.qute.api.ResourcePath;
import io.quarkus.qute.api.VariantTemplate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class MailTemplateProducer {
    private static final Logger LOGGER = Logger.getLogger(MailTemplateProducer.class);
    @Inject
    MutinyMailerImpl mailer;
    @Any
    Instance<VariantTemplate> template;

    @Produces
    MailTemplate getDefault(InjectionPoint injectionPoint) {
        String name;
        if (injectionPoint.getMember() instanceof Field) {
            name = injectionPoint.getMember().getName();
        } else {
            AnnotatedParameter parameter = (AnnotatedParameter)injectionPoint.getAnnotated();
            if (parameter.getJavaParameter().isNamePresent()) {
                name = parameter.getJavaParameter().getName();
            } else {
                name = injectionPoint.getMember().getName();
                LOGGER.warnf("Parameter name not present - using the method name as the template name instead %s", (Object)name);
            }
        }
        return new MailTemplate(){

            @Override
            public MailTemplate.MailTemplateInstance instance() {
                return new MailTemplateInstanceImpl(MailTemplateProducer.this.mailer, ((VariantTemplate)MailTemplateProducer.this.template.select(new Annotation[]{new ResourcePath.Literal(name)}).get()).instance());
            }
        };
    }

    @ResourcePath(value="ignored")
    @Produces
    MailTemplate get(InjectionPoint injectionPoint) {
        ResourcePath path = null;
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ResourcePath.class)) continue;
            path = (ResourcePath)qualifier;
            break;
        }
        if (path == null || path.value().isEmpty()) {
            throw new IllegalStateException("No template resource path specified");
        }
        final String name = path.value();
        return new MailTemplate(){

            @Override
            public MailTemplate.MailTemplateInstance instance() {
                return new MailTemplateInstanceImpl(MailTemplateProducer.this.mailer, ((VariantTemplate)MailTemplateProducer.this.template.select(new Annotation[]{new ResourcePath.Literal(name)}).get()).instance());
            }
        };
    }
}

